/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application;

import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.helper.WeakPropertyChangeListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class ActionUICommand
implements UICommand {
    private final Action action;
    private final Property<String> titleProperty;
    private final MutableProperty<Boolean> enabledProperty;
    private Property<String> keystrokeProperty;
    private Property<String> mnemonicProperty;
    private Property<Object> iconProperty;

    public ActionUICommand(final Action action) {
        this.action = action;
        this.titleProperty = new ActionProperty("Name");
        this.enabledProperty = new ActionProperty<Boolean>("enabled"){

            @Override
            public void setValue(Boolean value) {
                action.setEnabled(value);
            }

            @Override
            public Boolean getValue() {
                return action.isEnabled();
            }
        };
        this.keystrokeProperty = new KeyStrokeActionProperty("AcceleratorKey");
        this.iconProperty = new ActionProperty("SmallIcon");
    }

    public Property<String> titleProperty() {
        return this.titleProperty;
    }

    public MutableProperty<Boolean> enabledProperty() {
        return this.enabledProperty;
    }

    public Property<String> keystrokeProperty() {
        return this.keystrokeProperty;
    }

    public Property<String> mnemonicProperty() {
        return this.mnemonicProperty;
    }

    public Property<Object> iconProperty() {
        return this.iconProperty;
    }

    public void execute(Object source) {
        this.action.actionPerformed(new ActionEvent(source, 0, null));
    }

    protected class ActionProperty<T>
    extends AbstractMutableProperty<T> {
        private String key;
        final WeakPropertyChangeListener listener;

        public ActionProperty(String key) {
            this.listener = new WeakPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(ActionProperty.this.key)) {
                        ActionProperty.this.notifyPropertyChanged(new PropertyEvent(evt.getOldValue(), evt.getNewValue()));
                    }
                }
            }, (Object)ActionUICommand.this.action);
            this.key = key;
            if (ActionUICommand.this.action != null) {
                ActionUICommand.this.action.addPropertyChangeListener((PropertyChangeListener)this.listener);
            }
        }

        public void setValue(T value) {
            ActionUICommand.this.action.putValue(this.key, value);
        }

        public T getValue() {
            return (T)ActionUICommand.this.action.getValue(this.key);
        }
    }

    protected class KeyStrokeActionProperty
    extends AbstractMutableProperty<String> {
        private String key;

        public KeyStrokeActionProperty(final String key) {
            this.key = key;
            if (ActionUICommand.this.action != null) {
                ActionUICommand.this.action.addPropertyChangeListener((PropertyChangeListener)new WeakPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals(key)) {
                            KeyStrokeActionProperty.this.notifyPropertyChanged(new PropertyEvent((Object)(evt.getOldValue() != null ? evt.getOldValue().toString() : null), evt.getNewValue() != null ? evt.getNewValue().toString() : null));
                        }
                    }
                }, (Object)ActionUICommand.this.action));
            }
        }

        public void setValue(String value) {
            ActionUICommand.this.action.putValue(this.key, KeyStroke.getKeyStroke(value));
        }

        public String getValue() {
            Object value = ActionUICommand.this.action.getValue(this.key);
            return value != null ? value.toString() : null;
        }
    }
}

