/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.DataHelper;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.SimpleMutableDataModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;

public class SSA2TXT {
    private static String[] files = new String[]{"SSA-1990s-male.txt", "SSA-1990s-female.txt", "SSA-1980s-male.txt", "SSA-1980s-female.txt", "SSA-1970s-male.txt", "SSA-1970s-female.txt", "SSA-1960s-male.txt", "SSA-1960s-female.txt", "SSA-1950s-male.txt", "SSA-1950s-female.txt", "SSA-1940s-male.txt", "SSA-1940s-female.txt", "SSA-1930s-male.txt", "SSA-1930s-female.txt", "SSA-1920s-male.txt", "SSA-1920s-female.txt", "SSA-1910s-male.txt", "SSA-1910s-female.txt", "SSA-1900s-male.txt", "SSA-1900s-female.txt"};

    public SSA2TXT(String output) {
        DataModel[] dataModels = new DataModel[files.length];
        Class[] classes = new Class[1 + files.length / 2 * 5];
        Object[] labels = new String[1 + files.length / 2 * 5];
        classes[0] = String.class;
        labels[0] = "Name";
        for (int i = 0; i < files.length / 2; ++i) {
            classes[i * 5 + 1] = Integer.class;
            classes[i * 5 + 2] = Integer.class;
            classes[i * 5 + 3] = Integer.class;
            classes[i * 5 + 4] = Integer.class;
            classes[i * 5 + 5] = Integer.class;
            labels[i * 5 + 1] = "Number " + files[i * 2].substring(4, 9);
            labels[i * 5 + 2] = "Number male " + files[i * 2].substring(4, 9);
            labels[i * 5 + 3] = "Number female " + files[i * 2].substring(4, 9);
            labels[i * 5 + 4] = "Rank male " + files[i * 2].substring(4, 9);
            labels[i * 5 + 5] = "Rank female " + files[i * 2].substring(4, 9);
        }
        SimpleMutableDataModel mutableDataModel = new SimpleMutableDataModel(labels, classes);
        for (int i = 0; i < files.length; ++i) {
            BufferedReader reader = null;
            try {
                FileInputStream in = new FileInputStream(files[i]);
                reader = new BufferedReader(new InputStreamReader(in));
            }
            catch (Exception in) {
                // empty catch block
            }
            dataModels[i] = new SimpleDataModel(reader);
            int nameIndex = dataModels[i].getColumnIndex("Name");
            int rankIndex = dataModels[i].getColumnIndex("Rank");
            int numberIndex = dataModels[i].getColumnIndex("Number");
            int sexShift = 0;
            if (!files[i].substring(10, 14).equals("male")) {
                sexShift = 1;
            }
            for (int row = 0; row < dataModels[i].getRowCount(); ++row) {
                if (!dataModels[i].isAvailable(row, nameIndex)) continue;
                String name = (String)dataModels[i].getValueAt(row, nameIndex);
                Integer rank = (Integer)dataModels[i].getValueAt(row, rankIndex);
                Integer number = (Integer)dataModels[i].getValueAt(row, numberIndex);
                int found = -1;
                for (int rowM = 0; rowM < mutableDataModel.getRowCount(); ++rowM) {
                    if (!name.equals(mutableDataModel.getValueAt(rowM, 0))) continue;
                    found = rowM;
                }
                if (found == -1) {
                    mutableDataModel.addRow(this);
                    found = mutableDataModel.getRowCount() - 1;
                }
                mutableDataModel.setObject(this, found, 0, name);
                mutableDataModel.setObject(this, found, i / 2 * 5 + 2 + sexShift, number);
                mutableDataModel.setObject(this, found, i / 2 * 5 + 4 + sexShift, rank);
            }
        }
        for (int rowM = 0; rowM < mutableDataModel.getRowCount(); ++rowM) {
            for (int i = 0; i < files.length / 2; ++i) {
                int total = 0;
                if (mutableDataModel.isAvailable(rowM, i * 5 + 2)) {
                    total += ((Integer)mutableDataModel.getValueAt(rowM, i * 5 + 2)).intValue();
                }
                if (mutableDataModel.isAvailable(rowM, i * 5 + 3)) {
                    total += ((Integer)mutableDataModel.getValueAt(rowM, i * 5 + 3)).intValue();
                }
                mutableDataModel.setObject(this, rowM, i * 5 + 1, total);
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            DataHelper.saveTxt((DataModel)mutableDataModel, out);
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void main(String[] argv) {
        try {
            SSA2TXT s = new SSA2TXT(argv[0]);
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Usage: SSA2TXT output.txt");
            Logging.getInstance().process((Throwable)e);
        }
    }
}

