/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.column;

import com.macrofocus.data.column.AbstractColumnModel;
import com.macrofocus.data.column.ColumnModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SimpleColumnModel<O>
extends AbstractColumnModel<O>
implements Externalizable {
    static final long serialVersionUID = 8291048985079302622L;
    private Object[] objects;
    private Class membership;
    private Object name;
    private boolean isEditable;

    public SimpleColumnModel() {
        this.name = null;
        this.membership = Object.class;
        this.objects = new Object[0];
        this.isEditable = false;
    }

    public SimpleColumnModel(ColumnModel columnModel) {
        this.name = columnModel.getName();
        this.membership = columnModel.getMembership();
        this.objects = new Object[columnModel.getRowCount()];
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i] = columnModel.isAvailable(i) ? columnModel.getObject(i) : null;
        }
        this.isEditable = columnModel.isEditable();
    }

    public SimpleColumnModel(Object name, Class membership, Object[] objects) {
        this(name, membership, objects, false);
    }

    public SimpleColumnModel(Object name, Class membership, Object[] objects, boolean isEditable) {
        this.name = name;
        this.membership = membership;
        this.objects = objects;
        this.isEditable = isEditable;
    }

    @Override
    public boolean isAvailable(int index) {
        return this.objects[index] != null;
    }

    @Override
    public O getObject(int index) {
        return (O)this.objects[index];
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public Class getMembership() {
        return this.membership;
    }

    @Override
    public int getRowCount() {
        return this.objects.length;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setObject(int index, O value) {
        this.objects[index] = value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeInt(this.getRowCount());
        out.writeObject(this.getName());
        out.writeObject(this.getMembership());
        out.writeBoolean(this.isEditable());
        for (int row = 0; row < this.getRowCount(); ++row) {
            out.writeBoolean(this.isAvailable(row));
        }
        Class cl = this.getMembership();
        if (cl == Double.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeDouble((Double)this.objects[row]);
            }
        } else if (cl == Float.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeFloat(((Float)this.objects[row]).floatValue());
            }
        } else if (cl == Long.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeLong((Long)this.objects[row]);
            }
        } else if (cl == Integer.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeInt((Integer)this.objects[row]);
            }
        } else if (cl == Short.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeShort(((Short)this.objects[row]).shortValue());
            }
        } else if (cl == Byte.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeByte(((Byte)this.objects[row]).byteValue());
            }
        } else if (cl == Boolean.class) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeBoolean((Boolean)this.objects[row]);
            }
        } else {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row)) continue;
                out.writeObject(this.objects[row]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        block23: {
            int version = in.readInt();
            if (version <= 0) break block23;
            int rowCount = in.readInt();
            this.name = in.readObject();
            this.membership = (Class)in.readObject();
            this.isEditable = in.readBoolean();
            this.objects = new Object[rowCount];
            boolean[] isAvailable = new boolean[rowCount];
            for (int row = 0; row < this.getRowCount(); ++row) {
                isAvailable[row] = in.readBoolean();
            }
            Class cl = this.getMembership();
            if (cl == Double.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Double.valueOf(in.readDouble()) : null;
                }
            } else if (cl == Float.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Float.valueOf(in.readFloat()) : null;
                }
            } else if (cl == Long.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Long.valueOf(in.readLong()) : null;
                }
            } else if (cl == Integer.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Integer.valueOf(in.readInt()) : null;
                }
            } else if (cl == Short.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Short.valueOf(in.readShort()) : null;
                }
            } else if (cl == Byte.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Byte.valueOf(in.readByte()) : null;
                }
            } else if (cl == Boolean.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? Boolean.valueOf(in.readBoolean()) : null;
                }
            } else {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row] = isAvailable[row] ? in.readObject() : null;
                }
            }
        }
    }
}

