/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.DatabaseDriverFactory;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class OpenDatabaseDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JComboBox driverComboBox;
    private JFormattedTextField hostTextField;
    private JFormattedTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JComboBox databaseComboBox;
    private JComboBox tableComboBox;
    private JFormattedTextField urlTextField;
    private JButton listDatabasesButton;
    private JEditorPane queryEditorPane;
    private JCheckBox urlCheckBox;
    private JCheckBox queryCheckBox;
    private JButton listTablesButton;
    private final MutableSingleSelection<DatabaseDriver> driver = new SimpleSingleSelection((Object)DatabaseDriverFactory.getDefault());
    MutableSingleSelection<String> schema = new SimpleSingleSelection();
    MutableSingleSelection<String> table = new SimpleSingleSelection();
    private Action action;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public OpenDatabaseDialog() {
        this.$$$setupUI$$$();
        this.setTitle("Open Database");
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.urlCheckBox.setFocusable(false);
        this.queryCheckBox.setFocusable(false);
        this.usernameTextField.setText("root");
        this.passwordTextField.setText("");
        this.hostTextField.setText("localhost");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
            }
        };
        this.usernameTextField.getDocument().addDocumentListener(documentListener);
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        SingleSelectionComboBoxModel driverModel = new SingleSelectionComboBoxModel(this.driver, DatabaseDriverFactory.getDatabaseDrivers());
        this.driverComboBox.setModel(driverModel);
        this.driver.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<DatabaseDriver>(){

            public void selectionChanged(SingleSelectionEvent<DatabaseDriver> event) {
                OpenDatabaseDialog.this.updateState();
                OpenDatabaseDialog.this.updateURL();
            }
        });
        this.urlCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OpenDatabaseDialog.this.updateState();
            }
        });
        this.queryCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OpenDatabaseDialog.this.updateState();
            }
        });
        JTextComponent tcDatabaseComboBox = (JTextComponent)this.databaseComboBox.getEditor().getEditorComponent();
        tcDatabaseComboBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
                OpenDatabaseDialog.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
                OpenDatabaseDialog.this.updateState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateURL();
                OpenDatabaseDialog.this.updateState();
            }
        });
        this.databaseComboBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.updateURL();
                OpenDatabaseDialog.this.updateState();
            }
        }, (Object)this.databaseComboBox));
        this.listDatabasesButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.updateDatabases();
            }
        }, (Object)this.listDatabasesButton));
        this.listTablesButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.updateTables();
            }
        }, (Object)this.listTablesButton));
        JTextComponent tcTableComboBox = (JTextComponent)this.tableComboBox.getEditor().getEditorComponent();
        tcTableComboBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateQuery();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateQuery();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OpenDatabaseDialog.this.updateQuery();
            }
        });
        this.tableComboBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.updateQuery();
            }
        }, (Object)this.tableComboBox));
        this.updateState();
        this.updateURL();
        this.buttonOK.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.onOK();
            }
        }, (Object)this.buttonOK));
        this.buttonCancel.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.onCancel();
            }
        }, (Object)this.buttonCancel));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenDatabaseDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenDatabaseDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        try {
            if (DriverManager.getDriver(this.urlTextField.getText()).acceptsURL(this.urlTextField.getText())) {
                this.action.actionPerformed(new ActionEvent(this, 0, null));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void updateState() {
        boolean driverSelected = this.driver.isActive();
        boolean manualUrl = this.urlCheckBox.isSelected();
        boolean manualQuery = this.queryCheckBox.isSelected();
        Object database = this.databaseComboBox.getEditor().getItem();
        boolean datatabaseSelected = driverSelected && (database != null && !database.equals("") || manualUrl);
        this.driverComboBox.setEnabled(!manualUrl);
        this.usernameTextField.setEnabled(driverSelected);
        this.passwordTextField.setEnabled(driverSelected);
        this.hostTextField.setEnabled(driverSelected && ((DatabaseDriver)this.driver.getSelected()).isNetworkEnabled() && !manualUrl);
        this.databaseComboBox.setEnabled(driverSelected && !manualUrl);
        this.databaseComboBox.setEditable(driverSelected && !manualUrl);
        this.listDatabasesButton.setEnabled(driverSelected);
        this.urlTextField.setEnabled(driverSelected && manualUrl);
        this.urlCheckBox.setEnabled(driverSelected);
        this.tableComboBox.setEnabled(datatabaseSelected);
        this.tableComboBox.setEditable(datatabaseSelected);
        this.listTablesButton.setEnabled(datatabaseSelected && !manualQuery);
        this.queryEditorPane.setEnabled(datatabaseSelected && manualQuery);
        this.queryCheckBox.setEnabled(datatabaseSelected);
        this.buttonOK.setEnabled(driverSelected);
    }

    void updateURL() {
        if (!this.urlCheckBox.isSelected()) {
            DatabaseDriver selectedDriver = (DatabaseDriver)this.driver.getSelected();
            if (selectedDriver != null) {
                this.urlTextField.setText(selectedDriver.getURL(this.hostTextField.getText(), (String)this.databaseComboBox.getEditor().getItem(), this.usernameTextField.getText(), new String(this.passwordTextField.getPassword())));
            } else {
                this.urlTextField.setText(null);
            }
        }
    }

    void updateDatabases() {
        this.databaseComboBox.removeAllItems();
        try {
            char[] charsPassword = this.passwordTextField.getPassword();
            String username = this.usernameTextField.getText();
            String password = charsPassword != null ? new String(charsPassword) : null;
            for (String database : ((DatabaseDriver)this.driver.getSelected()).getDatabases(this.hostTextField.getText(), username, password)) {
                this.databaseComboBox.addItem(database);
            }
        }
        catch (SQLException e) {
            SwingLogging.getInstance().process((Component)this, (Throwable)e);
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), this.toString() + "Error", 0);
        }
        if (this.databaseComboBox.getItemCount() > 0) {
            this.databaseComboBox.setSelectedIndex(0);
        }
    }

    void updateTables() {
        this.tableComboBox.removeAllItems();
        try {
            Iterable<String> iterable = ((DatabaseDriver)this.driver.getSelected()).getTables(this.urlTextField.getText(), (String)this.databaseComboBox.getEditor().getItem(), this.usernameTextField.getText(), new String(this.passwordTextField.getPassword()));
            if (iterable != null) {
                for (String table : iterable) {
                    this.tableComboBox.addItem(table);
                }
            }
        }
        catch (SQLException e) {
            SwingLogging.getInstance().process((Component)this, (Throwable)e);
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), this.toString() + "Error", 0);
        }
        if (this.tableComboBox.getItemCount() > 0) {
            this.tableComboBox.setSelectedIndex(0);
        }
    }

    void updateQuery() {
        if (!this.queryCheckBox.isSelected()) {
            Object table = this.tableComboBox.getEditor().getItem();
            if (table != null && !table.equals("")) {
                this.queryEditorPane.setText(((DatabaseDriver)this.driver.getSelected()).getQuery("SELECT * FROM " + String.valueOf(table)));
            } else {
                this.queryEditorPane.setText("");
            }
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.driver.getSelected();
    }

    public String getURL() {
        return this.urlTextField.getText();
    }

    public String getUsername() {
        return this.usernameTextField.getText();
    }

    public char[] getPassword() {
        return this.passwordTextField.getPassword();
    }

    public String getQuery() {
        return this.queryEditorPane.getText();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        panel2.add((Component)this.buttonOK, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        panel2.add((Component)this.buttonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Database driver:");
        panel3.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.driverComboBox = new JComboBox();
        panel3.add((Component)this.driverComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Username:");
        panel3.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.usernameTextField = new JFormattedTextField();
        panel3.add((Component)this.usernameTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Password:");
        panel3.add((Component)label3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.passwordTextField = new JPasswordField();
        panel3.add((Component)this.passwordTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel4.add((Component)panel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        JLabel label4 = new JLabel();
        label4.setText("Database name:");
        panel5.add((Component)label4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Host name:");
        panel5.add((Component)label5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.hostTextField = new JFormattedTextField();
        panel5.add((Component)this.hostTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel5.add((Component)panel6, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel6.add((Component)panel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.databaseComboBox = new JComboBox();
        panel7.add((Component)this.databaseComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.listDatabasesButton = new JButton();
        this.listDatabasesButton.setText("Reload");
        panel7.add((Component)this.listDatabasesButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel4.add((Component)panel8, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        JLabel label6 = new JLabel();
        label6.setText("URL:");
        panel8.add((Component)label6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel9 = new JPanel();
        panel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel8.add((Component)panel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null, 0, true));
        this.urlTextField = new JFormattedTextField();
        panel9.add((Component)this.urlTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.urlCheckBox = new JCheckBox();
        this.urlCheckBox.setText("");
        panel9.add((Component)this.urlCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel10 = new JPanel();
        panel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel10, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel label7 = new JLabel();
        label7.setText("Table name:");
        panel10.add((Component)label7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel11 = new JPanel();
        panel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel10.add((Component)panel11, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.tableComboBox = new JComboBox();
        panel11.add((Component)this.tableComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.listTablesButton = new JButton();
        this.listTablesButton.setText("Reload");
        panel11.add((Component)this.listTablesButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel12 = new JPanel();
        panel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel12, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel label8 = new JLabel();
        label8.setText("Query:");
        panel12.add((Component)label8, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        JPanel panel13 = new JPanel();
        panel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel12.add((Component)panel13, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.queryCheckBox = new JCheckBox();
        this.queryCheckBox.setText("");
        panel13.add((Component)this.queryCheckBox, new GridConstraints(0, 1, 1, 1, 9, 0, 3, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        panel13.add((Component)scrollPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, new Dimension(400, 80), null, 0, false));
        this.queryEditorPane = new JEditorPane();
        scrollPane1.setViewportView(this.queryEditorPane);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

