/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.PostgreSQLDatabaseDriver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.postgis.jdbc.PGboxbase;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.GeometryCollection;
import net.postgis.jdbc.geometry.Polygon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;

public class PostGISDatabaseDriver
extends PostgreSQLDatabaseDriver {
    private static final String className = "net.postgis.jdbc.DriverWrapper";
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    public static boolean exist() {
        return PostGISDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getPrefix() {
        return "postgresql_postGIS";
    }

    @Override
    public String toString() {
        return "PostGIS";
    }

    @Override
    public Class getColumnType(ResultSetMetaData metaData, int column) throws SQLException {
        if (metaData.getColumnType(column) == 1111) {
            return Geometry.class;
        }
        return super.getColumnType(metaData, column);
    }

    @Override
    public Object getColumnValue(ResultSet rs, Class columnType, int column) throws SQLException {
        if (columnType == Geometry.class) {
            Object o = rs.getObject(column);
            return this.convert2JTS(o);
        }
        return super.getColumnValue(rs, columnType, column);
    }

    public static GeometryFactory getGeometryFactory() {
        return geometryFactory;
    }

    public Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof net.postgis.jdbc.geometry.Geometry) {
            object = new PGgeometry((net.postgis.jdbc.geometry.Geometry)object);
        }
        if (object instanceof PGgeometry) {
            PGgeometry geom = (PGgeometry)object;
            Point out = null;
            switch (geom.getGeoType()) {
                case 1: {
                    out = this.convertPoint((net.postgis.jdbc.geometry.Point)geom.getGeometry());
                    break;
                }
                case 2: {
                    out = this.convertLineString((net.postgis.jdbc.geometry.LineString)geom.getGeometry());
                    break;
                }
                case 3: {
                    out = this.convertPolygon((Polygon)geom.getGeometry());
                    break;
                }
                case 5: {
                    out = this.convertMultiLineString((net.postgis.jdbc.geometry.MultiLineString)geom.getGeometry());
                    break;
                }
                case 4: {
                    out = this.convertMultiPoint((net.postgis.jdbc.geometry.MultiPoint)geom.getGeometry());
                    break;
                }
                case 6: {
                    out = this.convertMultiPolygon((net.postgis.jdbc.geometry.MultiPolygon)geom.getGeometry());
                    break;
                }
                case 7: {
                    out = this.convertGeometryCollection((GeometryCollection)geom.getGeometry());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type of PGgeometry");
                }
            }
            return out;
        }
        if (object instanceof PGboxbase) {
            return this.convertBox((PGboxbase)object);
        }
        throw new IllegalArgumentException("Can't convert object of type " + object.getClass().getCanonicalName());
    }

    private Geometry convertBox(PGboxbase box) {
        net.postgis.jdbc.geometry.Point ll = box.getLLB();
        net.postgis.jdbc.geometry.Point ur = box.getURT();
        Coordinate[] ringCoords = new Coordinate[]{new Coordinate(ll.x, ll.y), new Coordinate(ur.x, ll.y), new Coordinate(ur.x, ur.y), new Coordinate(ll.x, ur.y), new Coordinate(ll.x, ll.y)};
        LinearRing shell = PostGISDatabaseDriver.getGeometryFactory().createLinearRing(ringCoords);
        return PostGISDatabaseDriver.getGeometryFactory().createPolygon(shell, null);
    }

    private Geometry convertGeometryCollection(GeometryCollection collection) {
        net.postgis.jdbc.geometry.Geometry[] geometries = collection.getGeometries();
        Geometry[] jtsGeometries = new Geometry[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            jtsGeometries[i] = this.convert2JTS(geometries[i]);
        }
        return PostGISDatabaseDriver.getGeometryFactory().createGeometryCollection(jtsGeometries);
    }

    private Geometry convertMultiPolygon(net.postgis.jdbc.geometry.MultiPolygon pgMultiPolygon) {
        org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[pgMultiPolygon.numPolygons()];
        for (int i = 0; i < polygons.length; ++i) {
            Polygon pgPolygon = pgMultiPolygon.getPolygon(i);
            polygons[i] = (org.locationtech.jts.geom.Polygon)this.convertPolygon(pgPolygon);
        }
        MultiPolygon out = PostGISDatabaseDriver.getGeometryFactory().createMultiPolygon(polygons);
        out.setSRID(pgMultiPolygon.srid);
        return out;
    }

    private Geometry convertMultiPoint(net.postgis.jdbc.geometry.MultiPoint pgMultiPoint) {
        Point[] points = new Point[pgMultiPoint.numPoints()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = this.convertPoint(pgMultiPoint.getPoint(i));
        }
        MultiPoint out = PostGISDatabaseDriver.getGeometryFactory().createMultiPoint(points);
        out.setSRID(pgMultiPoint.srid);
        return out;
    }

    private Geometry convertMultiLineString(net.postgis.jdbc.geometry.MultiLineString mlstr) {
        LineString[] lstrs = new LineString[mlstr.numLines()];
        for (int i = 0; i < mlstr.numLines(); ++i) {
            lstrs[i] = PostGISDatabaseDriver.getGeometryFactory().createLineString(this.toJTSCoordinates(mlstr.getLine(i).getPoints()));
        }
        MultiLineString out = PostGISDatabaseDriver.getGeometryFactory().createMultiLineString(lstrs);
        out.setSRID(mlstr.srid);
        return out;
    }

    protected Geometry convertPolygon(Polygon polygon) {
        LinearRing shell = PostGISDatabaseDriver.getGeometryFactory().createLinearRing(this.toJTSCoordinates(polygon.getRing(0).getPoints()));
        org.locationtech.jts.geom.Polygon out = null;
        if (polygon.numRings() > 1) {
            LinearRing[] rings = new LinearRing[polygon.numRings() - 1];
            for (int r = 1; r < polygon.numRings(); ++r) {
                rings[r - 1] = PostGISDatabaseDriver.getGeometryFactory().createLinearRing(this.toJTSCoordinates(polygon.getRing(r).getPoints()));
            }
            out = PostGISDatabaseDriver.getGeometryFactory().createPolygon(shell, rings);
        } else {
            out = PostGISDatabaseDriver.getGeometryFactory().createPolygon(shell, null);
        }
        out.setSRID(polygon.srid);
        return out;
    }

    protected Point convertPoint(net.postgis.jdbc.geometry.Point pnt) {
        Point g = PostGISDatabaseDriver.getGeometryFactory().createPoint(new Coordinate(pnt.x, pnt.y));
        g.setSRID(pnt.getSrid());
        return g;
    }

    protected LineString convertLineString(net.postgis.jdbc.geometry.LineString lstr) {
        LineString out = PostGISDatabaseDriver.getGeometryFactory().createLineString(this.toJTSCoordinates(lstr.getPoints()));
        out.setSRID(lstr.getSrid());
        return out;
    }

    private Coordinate[] toJTSCoordinates(net.postgis.jdbc.geometry.Point[] points) {
        Coordinate[] coordinates = new Coordinate[points.length];
        for (int i = 0; i < points.length; ++i) {
            coordinates[i] = new Coordinate(points[i].x, points[i].y);
        }
        return coordinates;
    }
}

