/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.type.timeseries.TimeSeries;

public final class DataModelTimeSeries
implements TimeSeries {
    private final DataModel dataModel;
    private final int timeColumn;
    private final int valueColumn;
    private Long minTime = Long.MAX_VALUE;
    private Long maxTime = Long.MIN_VALUE;
    private final int first;
    private final int count;

    public DataModelTimeSeries(DataModel dataModel, int timeColumn, int valueColumn) {
        this(dataModel, timeColumn, valueColumn, 0, dataModel.getRowCount());
    }

    public DataModelTimeSeries(DataModel dataModel, int timeColumn, int valueColumn, int first, int count) {
        this.dataModel = dataModel;
        this.timeColumn = timeColumn;
        this.valueColumn = valueColumn;
        this.first = first;
        this.count = count;
        for (int i = 0; i < this.count; ++i) {
            long time = this.getTime(i);
            if (time < this.minTime) {
                this.minTime = time;
            }
            if (time <= this.maxTime) continue;
            this.maxTime = time;
        }
    }

    @Override
    public Class getType() {
        return this.dataModel.getColumnClass(this.valueColumn);
    }

    @Override
    public long getTime(int index) {
        return ((Number)this.dataModel.getValueAt(this.first + index, this.timeColumn)).longValue();
    }

    @Override
    public Object getValue(int index) {
        return this.dataModel.getValueAt(this.first + index, this.valueColumn);
    }

    @Override
    public int getItemCount() {
        return this.count;
    }

    @Override
    public long getMinTime() {
        return this.minTime;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }
}

