/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import java.text.DecimalFormat;

public class SavitzkyGolay {
    private static final float TINY = 1.0E-20f;

    public static void savgol(float[] c, int np, int nl, int nr, int ld, int m) {
        int kk;
        int mm;
        int k;
        float sum;
        if (np < nl + nr + 1 || nl < 0 || nr < 0 || ld > m || nl + nr < m) {
            System.err.println("bad args in savgol");
        }
        int[] indx = new int[m + 2];
        float[][] a = new float[m + 2][m + 2];
        float[] b = new float[m + 2];
        for (int ipj = 0; ipj <= m << 1; ++ipj) {
            sum = ipj != 0 ? 0.0f : 1.0f;
            for (k = 1; k <= nr; ++k) {
                sum = (float)((double)sum + Math.pow(k, ipj));
            }
            for (k = 1; k <= nl; ++k) {
                sum = (float)((double)sum + Math.pow(-k, ipj));
            }
            mm = Math.min(ipj, 2 * m - ipj);
            for (int imj = -mm; imj <= mm; imj += 2) {
                int i1 = 1 + (ipj + imj >> 1);
                int i2 = 1 + (ipj - imj >> 1);
                a[i1][i2] = sum;
            }
        }
        float d = SavitzkyGolay.ludcmp(a, m + 1, indx);
        for (int j = 1; j <= m + 1; ++j) {
            b[j] = 0.0f;
        }
        b[ld + 1] = 1.0f;
        SavitzkyGolay.lubksb(a, m + 1, indx, b);
        for (kk = 1; kk <= np; ++kk) {
            c[kk] = 0.0f;
        }
        for (k = -nl; k <= nr; ++k) {
            sum = b[1];
            float fac = 1.0f;
            for (mm = 1; mm <= m; ++mm) {
                sum += b[mm + 1] * (fac *= (float)k);
            }
            kk = (np - k) % np + 1;
            c[kk] = sum;
        }
    }

    private static float ludcmp(float[][] a, int n, int[] indx) {
        int j;
        float big;
        int i;
        int imax = 0;
        float[] vv = new float[n + 2];
        float d = 1.0f;
        for (i = 1; i <= n; ++i) {
            big = 0.0f;
            for (j = 1; j <= n; ++j) {
                float f;
                float temp = Math.abs(a[i][j]);
                if (!(f > big)) continue;
                big = temp;
            }
            if ((double)big == 0.0) {
                System.err.println("Singular matrix in routine ludcmp");
            }
            vv[i] = 1.0f / big;
        }
        for (j = 1; j <= n; ++j) {
            float dum;
            int k;
            float sum;
            for (i = 1; i < j; ++i) {
                sum = a[i][j];
                for (k = 1; k < i; ++k) {
                    sum -= a[i][k] * a[k][j];
                }
                a[i][j] = sum;
            }
            big = 0.0f;
            for (i = j; i <= n; ++i) {
                float f;
                sum = a[i][j];
                for (k = 1; k < j; ++k) {
                    sum -= a[i][k] * a[k][j];
                }
                a[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(f >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 1; k <= n; ++k) {
                    dum = a[imax][k];
                    a[imax][k] = a[j][k];
                    a[j][k] = dum;
                }
                d = -d;
                vv[imax] = vv[j];
            }
            indx[j] = imax;
            if ((double)a[j][j] == 0.0) {
                a[j][j] = 1.0E-20f;
            }
            if (j == n) continue;
            dum = 1.0f / a[j][j];
            for (i = j + 1; i <= n; ++i) {
                float[] fArray = a[i];
                int n2 = j;
                fArray[n2] = fArray[n2] * dum;
            }
        }
        return d;
    }

    private static void lubksb(float[][] a, int n, int[] indx, float[] b) {
        int j;
        float sum;
        int i;
        int ii = 0;
        for (i = 1; i <= n; ++i) {
            int ip = indx[i];
            sum = b[ip];
            b[ip] = b[i];
            if (ii != 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= a[i][j] * b[j];
                }
            } else if (sum != 0.0f) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = n; i >= 1; --i) {
            sum = b[i];
            for (j = i + 1; j <= n; ++j) {
                sum -= a[i][j] * b[j];
            }
            b[i] = sum / a[i][i];
        }
    }

    public static void main(String[] args) {
        int NTEST = 6;
        int NMAX = 1000;
        int[] mtest = new int[]{0, 2, 2, 2, 2, 4, 4};
        int[] nltest = new int[]{0, 2, 3, 4, 5, 4, 5};
        int[] nrtest = new int[]{0, 2, 1, 0, 5, 4, 5};
        String[] ans = new String[]{"", "                      -0.086  0.343  0.486  0.343 -0.086", "               -0.143  0.171  0.343  0.371  0.257", "         0.086 -0.143 -0.086  0.257  0.886", " -0.084  0.021  0.103  0.161  0.196  0.207  0.196  0.161  0.103  0.021 -0.084", "         0.035 -0.128  0.070  0.315  0.417  0.315  0.070 -0.128  0.035", "  0.042 -0.105 -0.023  0.140  0.280  0.333  0.280  0.140 -0.023 -0.105  0.042"};
        float[] c = new float[1000];
        System.out.println("\t\t\tSample Savitzky-Golay Coefficients");
        System.out.println("M nl nr");
        DecimalFormat format = new DecimalFormat("  0.000; -0.000");
        for (int i = 1; i <= 6; ++i) {
            int j;
            int m = mtest[i];
            int nl = nltest[i];
            int nr = nrtest[i];
            int np = nl + nr + 1;
            System.out.println(m + " " + nl + " " + nr);
            SavitzkyGolay.savgol(c, np, nl, nr, 0, m);
            float sum = 0.0f;
            for (j = 1; j <= np; ++j) {
                sum += c[j];
            }
            for (j = nl; j < 5; ++j) {
                System.out.print("       ");
            }
            for (j = nl + 1; j >= 1; --j) {
                String str = format.format(c[j]);
                System.out.print(str);
            }
            for (j = 0; j < nr; ++j) {
                System.out.print(format.format(c[np - j]));
            }
            System.out.println();
            System.out.println("Sum = " + sum);
            System.out.println("Compare answer:");
            System.out.println(ans[i]);
        }
    }
}

