/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole;

import com.macrofocus.util.ole.AbstractBlockModel;

public class HeaderBlockModel
extends AbstractBlockModel {
    public HeaderBlockModel(byte[] block) {
        super(block);
    }

    public boolean isMagic() {
        return this.toInt4(0) == -535703600 && this.toInt4(4) == -518344287;
    }

    public int getBbdBlockCount() {
        return this.toInt4(44);
    }

    public int getXBbdBlockCount() {
        return this.toInt4(72);
    }

    public int getRootBlock() {
        return this.toInt4(48);
    }

    public int getSbdBlock() {
        return this.toInt4(60);
    }

    public int getXSbdBlock() {
        return this.toInt4(68);
    }

    public int getBbdBlock(int i) {
        return this.toInt4(76 + i * 4);
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + "[num_of_bbd_blocks=" + this.getBbdBlockCount() + ",num_of_xbbd_blocks=" + this.getXBbdBlockCount() + ",root_startblock=" + this.getRootBlock() + ",sbd_startblock=" + this.getSbdBlock() + ",bbd_list=";
        for (int i = 0; i < this.getBbdBlockCount(); ++i) {
            s = s + this.getBbdBlock(i) + "/";
        }
        s = s + "]";
        return s;
    }
}

