/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentState;
import com.macrofocus.application.document.View;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.collection.Collections;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DocumentBasedApplicationState<Window, Component, D extends Document, V extends View<Component, D>> {
    private final Map<V, CPWindow> viewWindow;
    private final Map<CPWindow, V> windowView;
    private Deque<DocumentState> recent;
    private List<Listener> listeners = new ArrayList<Listener>();

    public DocumentBasedApplicationState(String[] urls) {
        this.viewWindow = new HashMap<V, CPWindow>();
        this.windowView = new HashMap<CPWindow, V>();
        this.recent = new ArrayDeque<DocumentState>(10);
        if (urls != null) {
            HashSet<String> set = new HashSet<String>(urls.length);
            for (String url : urls) {
                if (set.contains(url)) continue;
                set.add(url);
                DocumentState state = new DocumentState(url);
                this.recent.addLast(state);
            }
        }
    }

    public DocumentBasedApplicationState() {
        this(null);
    }

    public Iterable<CPWindow> getWindows() {
        return this.windowView.keySet();
    }

    public Iterable<V> getViews() {
        return this.viewWindow.keySet();
    }

    public V getView(CPWindow window) {
        return (V)((View)this.windowView.get(window));
    }

    public CPWindow getWindow(V view) {
        return this.viewWindow.get(view);
    }

    public void add(CPWindow window, V view) {
        assert (window != null);
        assert (view != null);
        CPWindow w = this.getWindow(view);
        V v = this.getView(window);
        this.remove(v);
        this.remove(w);
        this.remove(view);
        this.remove(window);
        this.viewWindow.put((CPWindow)view, window);
        this.windowView.put(window, view);
        final Object d = view.getDocument();
        if (d != null) {
            Collections.removeIf(this.recent, (Predicate)new Predicate<DocumentState>(){

                @Override
                public boolean test(DocumentState documentState) {
                    return documentState.getUrl().equals(d.getDocumentState().getUrl());
                }
            });
            this.recent.addFirst(d.getDocumentState());
            this.triggerRecentChanged();
        }
        assert (this.windowView.size() == this.viewWindow.size());
    }

    public void remove(CPWindow window) {
        View view = (View)this.windowView.get(window);
        this.windowView.remove(window);
        this.viewWindow.remove(view);
        assert (this.windowView.size() == this.viewWindow.size());
    }

    public void remove(V view) {
        CPWindow window = this.viewWindow.get(view);
        this.windowView.remove(window);
        this.viewWindow.remove(view);
        assert (this.windowView.size() == this.viewWindow.size());
    }

    public boolean isEmpty() {
        assert (this.windowView.size() == this.viewWindow.size());
        return this.windowView.size() == 0;
    }

    public DocumentState[] getRecent() {
        return this.recent.toArray(new DocumentState[this.recent.size()]);
    }

    public String[] getRecentURLs() {
        String[] recent = new String[this.recent.size()];
        int i = 0;
        for (DocumentState documentState : this.recent) {
            recent[i] = documentState.getUrl();
            ++i;
        }
        return recent;
    }

    public void triggerRecentChanged() {
        for (Listener listener : this.listeners) {
            listener.recentChanged();
        }
    }

    public void triggerClossing() {
        for (Listener listener : this.listeners) {
            listener.recentChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void recentChanged();

        public void closing();
    }
}

