/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.systemmonitor;

import java.util.ArrayList;
import java.util.List;

class RingBuffer<T> {
    private int index;
    private T[] buffer;

    public RingBuffer(int size) {
        this.buffer = new Object[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T value) {
        T[] TArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer[this.index] = value;
            this.index = this.calcNextIndex(this.index, this.buffer.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getValues() {
        T[] TArray = this.buffer;
        synchronized (this.buffer) {
            ArrayList<T> list = new ArrayList<T>(this.buffer.length);
            if (this.buffer[this.index] == null) {
                int i = 0;
                while (i < this.index) {
                    list.add(this.buffer[i]);
                    ++i;
                }
            } else {
                int idx = this.index;
                int i = 0;
                while (i < this.buffer.length) {
                    list.add(this.buffer[idx]);
                    idx = this.calcNextIndex(idx, this.buffer.length);
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) {
        T[] TArray = this.buffer;
        synchronized (this.buffer) {
            int destIndex;
            int i;
            Object[] newBuffer = new Object[size];
            int srcIndex = this.calcPrevIndex(this.index, this.buffer.length);
            if (this.buffer[this.index] == null) {
                i = Math.min(this.index, size);
                destIndex = Math.min(newBuffer.length - 1, srcIndex);
            } else {
                i = Math.min(this.buffer.length, size);
                destIndex = Math.min(newBuffer.length - 1, this.buffer.length - 1);
            }
            this.index = this.calcNextIndex(destIndex, newBuffer.length);
            while (i > 0) {
                newBuffer[destIndex] = this.buffer[srcIndex];
                srcIndex = this.calcPrevIndex(srcIndex, this.buffer.length);
                destIndex = this.calcPrevIndex(destIndex, newBuffer.length);
                --i;
            }
            this.buffer = newBuffer;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getSize() {
        return this.buffer.length;
    }

    private int calcNextIndex(int i, int size) {
        if (++i >= size) {
            i = 0;
        }
        return i;
    }

    private int calcPrevIndex(int i, int size) {
        if (--i < 0) {
            i = size - 1;
        }
        return i;
    }
}

