/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.coordinate;

import com.macrofocus.drawing.coordinate.CoordinateEvent;
import com.macrofocus.drawing.coordinate.CoordinateListener;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import com.macrofocus.drawing.zoom.ZoomStrategy;
import java.util.Vector;

public class SimpleCoordinateSystemModel
implements CoordinateSystemModel {
    private int screenWidth;
    private int screenHeight;
    private double worldMinX;
    private double worldMaxX;
    private double worldMinY;
    private double worldMaxY;
    private double worldRangeX;
    private double worldRangeY;
    private double maxScreenWidth;
    private double maxScreenHeight;
    ZoomStrategy zoomStrategy = null;
    private boolean invertScreenY = true;
    private Vector coordinateListeners;

    public SimpleCoordinateSystemModel(int screenWidth, int screenHeight, double worldMinX, double worldMaxX, double worldMinY, double worldMaxY) {
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.worldMaxX = worldMaxX;
        this.worldMaxY = worldMaxY;
        this.worldMinX = worldMinX;
        this.worldMinY = worldMinY;
        this.worldRangeX = worldMaxX - worldMinX;
        this.worldRangeY = worldMaxY - worldMinY;
        this.maxScreenWidth = screenWidth - 1;
        this.maxScreenHeight = screenHeight - 1;
        this.coordinateListeners = new Vector();
    }

    @Override
    public void setInvertScreenY(boolean invertScreenY) {
        this.invertScreenY = invertScreenY;
        this.fireYRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setZoomStrategy(ZoomStrategy zoomStrategy) {
        this.zoomStrategy = zoomStrategy;
        this.fireXRangeChanged(new CoordinateEvent(this, this));
        this.fireYRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public ZoomStrategy getZoomStrategy() {
        return this.zoomStrategy;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
        this.maxScreenWidth = screenWidth - 1;
        this.fireXRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
        this.maxScreenHeight = screenHeight - 1;
        this.fireYRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setWorldMaxX(double worldMaxX) {
        this.worldMaxX = worldMaxX;
        this.worldRangeX = worldMaxX - this.worldMinX;
        this.fireXRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setWorldMaxY(double worldMaxY) {
        this.worldMaxY = worldMaxY;
        this.worldRangeY = worldMaxY - this.worldMinY;
        this.fireYRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setWorldMinX(double worldMinX) {
        this.worldMinX = worldMinX;
        this.worldRangeX = this.worldMaxX - worldMinX;
        this.fireXRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setWorldMinY(double worldMinY) {
        this.worldMinY = worldMinY;
        this.worldRangeY = this.worldMaxY - worldMinY;
        this.fireYRangeChanged(new CoordinateEvent(this, this));
    }

    @Override
    public void setWorldY(double worldMinY, double worldMaxY) {
        if (this.worldMinY != worldMinY || this.worldMaxY != worldMaxY) {
            this.worldMinY = worldMinY;
            this.worldMaxY = worldMaxY;
            this.worldRangeY = worldMaxY - worldMinY;
            this.fireYRangeChanged(new CoordinateEvent(this, this));
        }
    }

    @Override
    public double getWorldMinX() {
        return this.worldMinX;
    }

    @Override
    public double getWorldMaxX() {
        return this.worldMaxX;
    }

    @Override
    public double getWorldMinY() {
        return this.worldMinY;
    }

    @Override
    public double getWorldMaxY() {
        return this.worldMaxY;
    }

    @Override
    public double xScreenToWorld(int x) {
        double x_world = (double)x / this.maxScreenWidth;
        if (this.zoomStrategy != null) {
            x_world = this.zoomStrategy.zoomedXToWorldX(x_world);
        }
        return x_world * this.worldRangeX + this.worldMinX;
    }

    @Override
    public double yScreenToWorld(int y) {
        double y_world = this.invertScreenY ? (this.maxScreenHeight - (double)y) / this.maxScreenHeight : (double)y / this.maxScreenHeight;
        if (this.zoomStrategy != null) {
            y_world = this.zoomStrategy.zoomedYToWorldY(y_world);
        }
        return y_world * this.worldRangeY + this.worldMinY;
    }

    @Override
    public int xWorldToScreen(double x) {
        double x_zoomed = (x - this.worldMinX) / this.worldRangeX;
        if (this.zoomStrategy != null) {
            x_zoomed = this.zoomStrategy.worldXToZoomedX(x_zoomed);
        }
        int xt = (int)Math.round(x_zoomed * this.maxScreenWidth);
        return xt;
    }

    @Override
    public int yWorldToScreen(double y) {
        double y_zoomed = (y - this.worldMinY) / this.worldRangeY;
        if (this.zoomStrategy != null) {
            y_zoomed = this.zoomStrategy.worldYToZoomedY(y_zoomed);
        }
        if (this.invertScreenY) {
            y_zoomed = 1.0 - y_zoomed;
        }
        int yt = (int)Math.round(y_zoomed * this.maxScreenHeight);
        return yt;
    }

    @Override
    public double xWorldToNormalized(double x) {
        return (x - this.worldMinX) / this.worldRangeX;
    }

    @Override
    public double yWorldToNormalized(double y) {
        return (y - this.worldMinY) / this.worldRangeY;
    }

    @Override
    public double xNormalizedToWorld(double x) {
        return x * this.worldRangeX + this.worldMinX;
    }

    @Override
    public double yNormalizedToWorld(double y) {
        return y * this.worldRangeY + this.worldMinY;
    }

    @Override
    public int xNormalizedToScreen(double x) {
        return (int)(x * this.maxScreenWidth);
    }

    @Override
    public int yNormalizedToScreen(double y) {
        return (int)(y * this.maxScreenHeight);
    }

    @Override
    public double xScreenToNormalized(int x) {
        return (double)x / this.maxScreenWidth;
    }

    @Override
    public double yScreenToNormilized(int y) {
        return (double)y / this.maxScreenHeight;
    }

    @Override
    public void addCoordinateListener(CoordinateListener listener) {
        this.coordinateListeners.addElement(listener);
    }

    @Override
    public void removeCoordinateListener(CoordinateListener listener) {
        this.coordinateListeners.removeElement(listener);
    }

    private void fireXRangeChanged(CoordinateEvent event) {
        for (int i = 0; i < this.coordinateListeners.size(); ++i) {
            CoordinateListener coordinateListener = (CoordinateListener)this.coordinateListeners.elementAt(i);
            coordinateListener.xRangeChanged(event);
        }
    }

    private void fireYRangeChanged(CoordinateEvent event) {
        for (int i = 0; i < this.coordinateListeners.size(); ++i) {
            CoordinateListener coordinateListener = (CoordinateListener)this.coordinateListeners.elementAt(i);
            coordinateListener.yRangeChanged(event);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.screenWidth + ", " + this.screenHeight + ", " + this.worldMinX + ", " + this.worldMaxX + ", " + this.worldMinY + ", " + this.worldMaxY;
    }
}

