/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.adapter;

import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import javax.swing.SpinnerNumberModel;

public class MBoundedRangeSpinnerAdapter
extends SpinnerNumberModel {
    private MBoundedRangeModel boundedRangeModel;
    private Number stepSize;
    private Type type;
    private boolean updating = false;
    final MBoundedRangeListener listener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            if (!MBoundedRangeSpinnerAdapter.this.updating) {
                MBoundedRangeSpinnerAdapter.this.updating = true;
                MBoundedRangeSpinnerAdapter.this.fireStateChanged();
            }
            MBoundedRangeSpinnerAdapter.this.updating = false;
        }
    };

    public MBoundedRangeSpinnerAdapter(MBoundedRangeModel boundedRangeModel) {
        this(boundedRangeModel, null);
    }

    public MBoundedRangeSpinnerAdapter(MBoundedRangeModel boundedRangeModel, Number stepSize) {
        this(boundedRangeModel, stepSize, Type.StartValue);
    }

    public MBoundedRangeSpinnerAdapter(Number stepSize, Type type) {
        this.stepSize = stepSize;
        this.type = type;
    }

    public MBoundedRangeSpinnerAdapter(MBoundedRangeModel boundedRangeModel, Number stepSize, Type type) {
        this(stepSize, type);
        this.boundedRangeModel = boundedRangeModel;
        this.setBoundedRangeModel(boundedRangeModel);
    }

    private Object getSelf() {
        return this;
    }

    @Override
    public Object getValue() {
        if (this.boundedRangeModel != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    return this.boundedRangeModel.getValue();
                }
                case 1: {
                    return this.boundedRangeModel.getValue() + this.boundedRangeModel.getExtent();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (!this.updating) {
            if (value instanceof Number) {
                double newValue = 0.0;
                double newExtent = 0.0;
                switch (this.type.ordinal()) {
                    case 0: {
                        newValue = ((Number)value).doubleValue();
                        newExtent = this.boundedRangeModel.getValue() + this.boundedRangeModel.getExtent() - newValue;
                        break;
                    }
                    case 1: {
                        newValue = this.boundedRangeModel.getValue();
                        newExtent = ((Number)value).doubleValue() - newValue;
                    }
                }
                if (newValue < this.boundedRangeModel.getMinimum()) {
                    newValue = this.boundedRangeModel.getMinimum();
                }
                if (newValue > this.boundedRangeModel.getMaximum()) {
                    newValue = this.boundedRangeModel.getMaximum();
                }
                if (newExtent < 0.0) {
                    newExtent = 0.0;
                }
                if (newValue + newExtent > this.boundedRangeModel.getMaximum()) {
                    newExtent = this.boundedRangeModel.getMaximum() - newValue;
                }
                this.boundedRangeModel.setValue(this.getSelf(), newValue, newExtent);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public Number getStepSize() {
        if (this.stepSize != null) {
            return this.stepSize;
        }
        double range = this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum();
        int p = (int)Math.log10(range);
        return Math.pow(10.0, p) / 100.0;
    }

    @Override
    public void setStepSize(Number stepSize) {
        this.stepSize = stepSize.doubleValue();
        super.setStepSize(stepSize);
    }

    public Comparable getMinimum() {
        return Double.valueOf(this.boundedRangeModel.getMinimum());
    }

    public Comparable getMaximum() {
        return Double.valueOf(this.boundedRangeModel.getMaximum());
    }

    @Override
    public Object getNextValue() {
        if (this.boundedRangeModel != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    double value = this.boundedRangeModel.getValue();
                    return this.getNext(value);
                }
                case 1: {
                    double value = this.boundedRangeModel.getValue() + this.boundedRangeModel.getExtent();
                    return this.getNext(value);
                }
            }
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.boundedRangeModel != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    double value = this.boundedRangeModel.getValue();
                    return this.getPrevious(value);
                }
                case 1: {
                    double value = this.boundedRangeModel.getValue() + this.boundedRangeModel.getExtent();
                    return this.getPrevious(value);
                }
            }
        }
        return null;
    }

    private Object getNext(double value) {
        double roundValue = (double)Math.round(value / this.getStepSize().doubleValue()) * this.getStepSize().doubleValue();
        if (roundValue + this.getStepSize().doubleValue() <= this.boundedRangeModel.getMaximum()) {
            return roundValue + this.getStepSize().doubleValue();
        }
        return this.boundedRangeModel.getMaximum();
    }

    private Object getPrevious(double value) {
        double roundValue = (double)Math.round(value / this.getStepSize().doubleValue()) * this.getStepSize().doubleValue();
        if (roundValue - this.getStepSize().doubleValue() > this.boundedRangeModel.getMinimum()) {
            return roundValue - this.getStepSize().doubleValue();
        }
        return this.boundedRangeModel.getMinimum();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setBoundedRangeModel(MBoundedRangeModel boundedRangeModel) {
        if (this.boundedRangeModel != null) {
            this.boundedRangeModel.removeBoundedRangeListener(this.listener);
        }
        this.boundedRangeModel = boundedRangeModel;
        boundedRangeModel.addBoundedRangeListener(this.listener);
        this.fireStateChanged();
    }

    public static enum Type {
        StartValue,
        EndValue;

    }
}

