/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.coordinate;

import com.macrofocus.soom.lens.coordinate.AbstractCoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;

public class SimpleCoordinateAxisModel
extends AbstractCoordinateAxisModel {
    private int screenSize;
    private double worldMin;
    private double worldMax;
    private double worldRange;

    private SimpleCoordinateAxisModel(int screenSize, double worldMin, double worldMax, double worldRange, ZoomStrategy zoomStrategy, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        super(zoomStrategy, invertDeviceCoordinates, invertWorldCoordinates);
        this.screenSize = screenSize;
        this.worldMin = worldMin;
        this.worldMax = worldMax;
        this.worldRange = worldRange;
    }

    public SimpleCoordinateAxisModel(int screenSize, double worldMin, double worldMax) {
        this.screenSize = screenSize;
        this.worldMax = worldMax;
        this.worldMin = worldMin;
        this.worldRange = worldMax - worldMin;
    }

    public SimpleCoordinateAxisModel(double worldMin, double worldMax) {
        this(0, worldMin, worldMax);
    }

    @Override
    public int getScreenSize() {
        return this.screenSize;
    }

    @Override
    public void setScreenSize(int size) {
        if (this.screenSize != size) {
            this.screenSize = size;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Screen));
        }
    }

    @Override
    public void setWorld(double worldMinX, double worldMaxX) {
        if (this.worldMax != worldMaxX || this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldMax = worldMaxX;
            this.worldRange = worldMaxX - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMax(double worldMaxX) {
        if (this.worldMax != worldMaxX) {
            this.worldMax = worldMaxX;
            this.worldRange = worldMaxX - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMin(double worldMinX) {
        if (this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldRange = this.worldMax - worldMinX;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public double getWorldMin() {
        return this.worldMin;
    }

    @Override
    public double getWorldMax() {
        return this.worldMax;
    }

    @Override
    public double getWorldRange() {
        return this.worldRange;
    }

    @Override
    public void setViewport(double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewportMax(double viewportMaxX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewportMin(double viewportMinX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getViewportRange() {
        return 1.0;
    }

    @Override
    public double getViewportMin() {
        return 0.0;
    }

    @Override
    public double getViewportMax() {
        return 1.0;
    }

    @Override
    public SimpleCoordinateAxisModel copy() {
        return new SimpleCoordinateAxisModel(this.screenSize, this.worldMin, this.worldMax, this.worldRange, this.getZoomStrategy(), this.getDeviceCoordinatesInverted(), this.getWorldCoordinatesInverted());
    }
}

