/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.treetable;

import com.macrofocus.util.swing.treetable.TreeTableSelectionModel;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ListTreeTableSelectionModel
extends TreeTableSelectionModel {
    protected boolean updatingListSelectionModel;
    private JTree tree;

    public ListTreeTableSelectionModel() {
        this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    @Override
    public synchronized void clearSelection() {
        if (this.tree != null) {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.clearSelection();
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        } else {
            this.updatingListSelectionModel = true;
            super.clearSelection();
            this.updatingListSelectionModel = false;
        }
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateSelectedPathsFromSelectedRows(ListSelectionEvent event) {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                if (!event.getValueIsAdjusting()) {
                    int min = this.getListSelectionModel().getLeadSelectionIndex();
                    int max = this.getListSelectionModel().getAnchorSelectionIndex();
                    if (this.getListSelectionModel().isSelectionEmpty() || min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.getListSelectionModel().isSelectedIndex(counter) || (selPath = this.tree.getPathForRow(counter)) == null) continue;
                            super.setSelectionPath(selPath);
                        }
                        TreePath path = this.getSelectionPath();
                        int row = this.tree.getRowForPath(path);
                        if (path != null) {
                            this.getListSelectionModel().setLeadSelectionIndex(row);
                            this.getListSelectionModel().setAnchorSelectionIndex(row);
                        }
                    } else {
                        super.clearSelection();
                    }
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    @Override
    public synchronized void resetRowSelection() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    @Override
    public void setSelected(DefaultMutableTreeNode node) {
        this.setSelectionPath(new TreePath(node.getPath()));
    }

    @Override
    public DefaultMutableTreeNode getSelected() {
        return (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setSelectionPath(TreePath path) {
        if (this.tree != null) {
            if (this.updatingListSelectionModel) return;
            this.updatingListSelectionModel = true;
            try {
                if (path == null) return;
                super.setSelectionPath(path);
                int row = this.tree.getRowForPath(path);
                this.getListSelectionModel().setSelectionInterval(row, row);
                return;
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        } else {
            this.updatingListSelectionModel = true;
            super.setSelectionPath(path);
            this.updatingListSelectionModel = false;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            ListTreeTableSelectionModel.this.updateSelectedPathsFromSelectedRows(event);
        }
    }
}

