/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.treemap.DepthFactory;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;

class RenderingSettingsPanel<Component, Color, Font> {
    private final TreeMapSettings settings;
    private final CPFormPanel<Component> layout;

    public RenderingSettingsPanel(TreeMapModel treeMapModel, CPFactory<Component, Font, ?, Color> factory) {
        this.settings = treeMapModel.getSettings();
        this.layout = factory.createFormPanel();
        this.layout.add((CPComponent)factory.createLabel("Progressive:"), (CPComponent)factory.createComboBox(this.settings.getProgressiveSelection(), Iterables.forArray((Object[])TreeMapView.Progressive.values())));
        this.layout.add((CPComponent)factory.createLabel("Depth:"), (CPComponent)factory.createComboBox(this.settings.getDepthSelection(), (Iterable)DepthFactory.getInstance().getDepths()));
        this.layout.add((CPComponent)factory.createLabel("Ambient Light:"), (CPComponent)factory.createSlider(this.settings.getLightSourceAmbientInterval()));
        this.layout.add((CPComponent)factory.createLabel("Light Height:"), (CPComponent)factory.createSlider(this.settings.getLightSourceHeightInterval()));
        this.layout.add((CPComponent)factory.createLabel("Light Source X:"), (CPComponent)factory.createSlider(this.settings.getLightSourceXInterval()));
        this.layout.add((CPComponent)factory.createLabel("Light Source Y:"), (CPComponent)factory.createSlider(this.settings.getLightSourceYInterval()));
        this.layout.add((CPComponent)factory.createLabel("Light Source Z:"), (CPComponent)factory.createSlider(this.settings.getLightSourceZInterval()));
        this.layout.add((CPComponent)factory.createLabel("Border:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{factory.createColorPicker(this.settings.getDefaultFieldSettings().getBorderColorProperty()), factory.createDoubleSpinner(this.settings.getDefaultFieldSettings().getBorderThicknessInterval())}));
        this.layout.add((CPComponent)factory.createLabel("Selection:"), (CPComponent)factory.createColorPicker(this.settings.getSelectionColorProperty()));
        this.layout.add((CPComponent)factory.createLabel("Probing:"), (CPComponent)factory.createColorPicker(this.settings.getProbingColorProperty()));
        this.layout.add((CPComponent)factory.createLabel("Tooltip Background:"), (CPComponent)factory.createColorPicker(this.settings.getTooltipBackgroundProperty()));
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

