/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.file.CPDirectoryChooser;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.persistence.DefaultElementFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.persistence.xom.XomElement;
import com.macrofocus.persistence.xom.XomElementFactory;
import com.macrofocus.resources.ResourcesModel;
import com.treemap.AggregationFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.app.document.TreeMapApplication;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.document.persistence.TreeMapPersistence;
import com.treemap.app.java.document.persistence.DefaultColorMapState;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONML;
import org.json.JSONObject;
import org.json.JSONTokener;

public interface JavaTreeMapApplication<Window, Component, F, D extends TreeMapDocument>
extends TreeMapApplication<Window, Component, F, D> {
    public D createDocument(String var1, String var2, DataSource var3, MutableDataFrame<Integer, String, Object> var4);

    public CPDirectoryChooser<Window, File> getDirectoryChooser();

    public ResourcesModel getResourcesModel();

    public static void loadSettings(CPFactory factory, PaletteFactory paletteFactory, FormatFactory formatFactory, TreeMapDocument document, nu.xom.Element xml) {
        if (xml != null) {
            XomElementFactory elementFactory = new XomElementFactory();
            TreeMapPersistence persistance = new TreeMapPersistence(document, (CPColorFactory)factory, (CPFontFactory)factory, AggregationFactory.getInstance(), paletteFactory, formatFactory, AlgorithmFactory.getInstance(), (ElementFactory)elementFactory, new DefaultColorMapState(factory, paletteFactory, (ElementFactory)elementFactory));
            persistance.load((Element)new XomElement(xml));
        }
    }

    public static String saveToJSON(TreeMapDocument document, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory) throws IOException {
        Element root = JavaTreeMapApplication.save(document, null, colorFactory, fontFactory, paletteFactory, formatFactory);
        String jsonDataFrame = SwingDataFrameExporter.exportJSON((DataFrame)document.getDataFrame());
        JSONObject xxx = new JSONObject(new JSONTokener(jsonDataFrame));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XmlElementSerializer().write((OutputStream)out, root);
        JSONObject json = JSONML.toJSONObject((String)out.toString());
        JSONArray Obj1 = (JSONArray)xxx.get("data");
        JSONObject combined = new JSONObject();
        combined.put("data", (Object)Obj1);
        combined.put("TreeMap", (Object)json);
        return combined.toString();
    }

    public static <Color, Font> Element save(TreeMapDocument document, File file, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory) {
        DefaultElementFactory elementFactory = new DefaultElementFactory();
        TreeMapPersistence persistence = new TreeMapPersistence(document, colorFactory, fontFactory, AggregationFactory.getInstance(), paletteFactory, formatFactory, AlgorithmFactory.getInstance(), (ElementFactory)elementFactory, new DefaultColorMapState<Color>(colorFactory, paletteFactory, (ElementFactory)elementFactory));
        Element root = elementFactory.newElement("TreeMap");
        root.addAttribute(elementFactory.newAttribute("version", ApplicationModelFactory.TREEMAP_APP.getVersionModel().toString()));
        persistence.save(root, (Object)file);
        return root;
    }
}

