/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.data.source.ClipboardDataSource;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.treemap.app.java.document.JavaTreeMapApplication;
import com.treemap.app.java.document.JavaTreeMapDocument;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.sql.SQLException;

public class NewFromClipboardCommand<Window>
extends AbstractUICommand {
    private final JavaTreeMapApplication<Window, ?, ?, JavaTreeMapDocument> application;
    private final CPWindow window;

    public NewFromClipboardCommand(JavaTreeMapApplication<Window, ?, ?, JavaTreeMapDocument> application, CPWindow window) {
        super("New from Clipboard");
        this.application = application;
        this.window = window;
    }

    public void execute(Object source) {
        final Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = cb.getContents(null);
        try {
            DataFlavor htmlFlavor = new DataFlavor("text/html;class=java.lang.String");
            if (t.isDataFlavorSupported(htmlFlavor)) {
                DocumentOpener documentOpener = new DocumentOpener(){

                    public Document openDocument(CPWindow window) throws OpenDocumentException {
                        ClipboardDataSource dataSource = new ClipboardDataSource(cb);
                        try {
                            return NewFromClipboardCommand.this.application.createDocument("clipboard", "clipboard", (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataSource.loadDataFrame(null));
                        }
                        catch (IOException e) {
                            throw new OpenDocumentException("Cannot access clipboard", (Throwable)e);
                        }
                        catch (SQLException e) {
                            throw new OpenDocumentException("Cannot access clipboard", (Throwable)e);
                        }
                    }
                };
                this.application.openAndShowDocument(this.window, documentOpener, null);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                DocumentOpener documentOpener = new DocumentOpener(){

                    public Document openDocument(CPWindow window) throws OpenDocumentException {
                        ClipboardDataSource dataSource = new ClipboardDataSource(cb);
                        try {
                            return NewFromClipboardCommand.this.application.createDocument("clipboard", "clipboard", (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataSource.loadDataFrame(null));
                        }
                        catch (IOException e) {
                            throw new OpenDocumentException("Cannot access clipboard", (Throwable)e);
                        }
                        catch (SQLException e) {
                            throw new OpenDocumentException("Cannot access clipboard", (Throwable)e);
                        }
                    }
                };
                this.application.openAndShowDocument(this.window, documentOpener, null);
                return;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

