/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.data.db.OpenGoogleSpreadsheetDialog;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.GoogleSpreadsheetDataSource;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.util.logging.SwingLogging;
import com.treemap.app.java.document.JavaTreeMapApplication;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class OpenGoogleSpreadsheetCommand<Window>
implements Command {
    private final JavaTreeMapApplication application;
    private final CPWindow<Window, ?> window;
    private OpenGoogleSpreadsheetDialog dialog;
    JComponent contentPane = null;

    public OpenGoogleSpreadsheetCommand(JavaTreeMapApplication application, CPWindow<Window, ?> window) {
        this.application = application;
        this.window = window;
    }

    public void execute() {
        if (this.dialog == null) {
            this.dialog = new OpenGoogleSpreadsheetDialog();
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressMonitor progressMonitor = new ProgressMonitor(OpenGoogleSpreadsheetCommand.this.contentPane, "Retrieving dataset", "", 0, Integer.MAX_VALUE);
                    progressMonitor.setMillisToDecideToPopup(50);
                    progressMonitor.setMillisToPopup(50);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (OpenGoogleSpreadsheetCommand.this.contentPane != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        OpenGoogleSpreadsheetCommand.this.contentPane.setCursor(new Cursor(3));
                                    }
                                });
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        char[] chars = OpenGoogleSpreadsheetCommand.this.dialog.getPassword();
                                        String password = new String(chars);
                                        for (int i = 0; i < chars.length; ++i) {
                                            chars[i] = '\u0000';
                                        }
                                        final GoogleSpreadsheetDataSource dataSource = new GoogleSpreadsheetDataSource(OpenGoogleSpreadsheetCommand.this.dialog.getUsername(), password, OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet());
                                        DocumentOpener documentOpener = new DocumentOpener(){

                                            public Document openDocument(CPWindow window) throws OpenDocumentException {
                                                try {
                                                    MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
                                                    Object document = OpenGoogleSpreadsheetCommand.this.application.createDocument(OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet(), "googlespreadsheet://" + OpenGoogleSpreadsheetCommand.this.dialog.getSpreadsheet(), (DataSource)dataSource, (MutableDataFrame<Integer, String, Object>)dataFrame);
                                                    return document;
                                                }
                                                catch (Exception ex) {
                                                    throw new OpenDocumentException("Error", (Throwable)ex);
                                                }
                                            }
                                        };
                                        OpenGoogleSpreadsheetCommand.this.application.openAndShowDocument(OpenGoogleSpreadsheetCommand.this.window, documentOpener, null);
                                    }
                                    catch (Exception e) {
                                        SwingLogging.getInstance().process((Component)OpenGoogleSpreadsheetCommand.this.contentPane, (Throwable)e);
                                    }
                                }
                            });
                            if (OpenGoogleSpreadsheetCommand.this.contentPane != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        OpenGoogleSpreadsheetCommand.this.contentPane.setCursor(new Cursor(0));
                                    }
                                });
                            }
                        }
                    }).start();
                }
            };
            this.dialog.setAction((Action)action);
        }
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }
}

