/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.ScreenTransformHelper;
import com.macrofocus.geom.Shape;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.ScreenTransformRubberBand;
import com.macrofocus.transform.MutableOneDScreenTransform;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.RangesScreenTransformCoordinator;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import com.macrofocus.transform.SimpleOneDScreenTransform;
import com.macrofocus.transform.twod.MutableTwoDScreenTransform;
import com.macrofocus.transform.twod.SimpleTwoDScreenTransform;
import com.macrofocus.transform.twod.TwoDScreenTransform;
import com.treemap.Algorithm;
import com.treemap.C;
import com.treemap.DefaultTreeMapHeaderRenderer;
import com.treemap.DefaultTreeMapLabelRenderer;
import com.treemap.DefaultTreeMapToolTip;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.L;
import com.treemap.S;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.d;
import com.treemap.e;
import com.treemap.g;
import com.treemap.q;
import com.treemap.t;
import com.treemap.tagcloud.TextShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTreeMapView<C, N, Row, Column, Color, Font>
implements TreeMapView<C, N, Row, Column, Color, Font> {
    protected final MutableBoundedInterval xRangeModel;
    protected final MutableBoundedInterval yRangeModel;
    protected final MutableTwoDScreenTransform screenTransform;
    protected final List<TreeMapRenderer> _preRenderers;
    protected final List<TreeMapRenderer> _preProgressiveRenderers;
    protected final List<TreeMapRenderer> _progressiveRenderers;
    protected final List<TreeMapRenderer> _postRenderers;
    protected final Map<N, Shape> _shapes;
    final SingleSelectionListener<N> a = new SingleSelectionListener<N>(){

        public void selectionChanged(SingleSelectionEvent<N> event) {
            TreeMapToolTip treeMapToolTip = AbstractTreeMapView.this.getToolTip();
            if (treeMapToolTip != null) {
                Object object = AbstractTreeMapView.this.getModel().getProbing().getSelected();
                AbstractTreeMapView.this.probingToolTip.showNode(object);
            }
            AbstractTreeMapView.this.repaint();
        }
    };
    final SelectionListener<N> b = new SelectionListener<N>(){

        public void selectionChanged(SelectionEvent<N> event) {
            TreeMapToolTip treeMapToolTip = AbstractTreeMapView.this.getSelectionToolTip();
            if (treeMapToolTip != null) {
                if (AbstractTreeMapView.this.getModel().getSelection().isActive() && AbstractTreeMapView.this.getModel().getSelection().getSelectedCount() == 1) {
                    Object e2 = AbstractTreeMapView.this.getModel().getSelection().iterator().next();
                    AbstractTreeMapView.this.selectionToolTip.showNode(e2);
                } else {
                    AbstractTreeMapView.this.selectionToolTip.showNode(null);
                }
            }
            AbstractTreeMapView.this.repaint();
        }
    };
    private final TreeMapListener c = new TreeMapListener(){

        @Override
        public void tableModelChanged() {
        }

        @Override
        public void treeMapChanged(TreeMapEvent event) {
            if (event.isLayoutChanged()) {
                AbstractTreeMapView.this.b();
                AbstractTreeMapView.this.repaint();
            } else {
                AbstractTreeMapView.this.a();
            }
        }
    };
    private final PropertiesListener d = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            if (!"progress".equals(name)) {
                AbstractTreeMapView.this.repaint();
            } else {
                AbstractTreeMapView.this.b();
                AbstractTreeMapView.this.repaint(300L);
            }
        }
    };
    private final FilterListener<N> e = new FilterListener<N>(){

        public void filterChanged(FilterEvent event) {
            AbstractTreeMapView.this.repaint(10L);
        }
    };
    private final PropertiesListener f = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            if ("dimension".equals(name) || "labeling".equals(name) || "heightField".equals(name) || "groupByField".equals(name)) {
                AbstractTreeMapView.this.updateSize();
            } else if ("dimensionFixed".equals(name)) {
                AbstractTreeMapView.this.updateModelDimension();
            }
            AbstractTreeMapView.this.repaint();
        }
    };
    protected TreeMapModel<N, Row, Column, Color, Font> _model;
    protected TreeMapLabelRenderer<C, N, Row, Column, Color, Font> labelRenderer;
    protected TreeMapHeaderRenderer<N, Row, Column, Color, Font> headerRenderer;
    protected TreeMapTooltipRenderer<C, N, Row, Column, Color, Font> tooltipRenderer;
    protected TreeMapToolTip probingToolTip = null;
    protected TreeMapToolTip selectionToolTip = null;
    private boolean g = true;
    protected TreeMapView.Progressive _progressive = TreeMapView.Progressive.Disabled;
    protected boolean _showTiming = false;
    private boolean h = true;
    private RubberBand i;
    private boolean j = true;
    private final Headless<Color, Font> k;

    public AbstractTreeMapView(Headless<Color, Font> headless) {
        this.k = headless;
        this._preRenderers = new ArrayList<TreeMapRenderer>();
        this._preProgressiveRenderers = new ArrayList<TreeMapRenderer>();
        this._progressiveRenderers = new ArrayList<TreeMapRenderer>();
        this._postRenderers = new ArrayList<TreeMapRenderer>();
        this._shapes = new HashMap<N, Shape>();
        this.addPreRenderer(new e());
        this.addPreRenderer(new C(new d(), 0));
        this.addPreProgressiveRenderer(new C(new t(false), 0));
        this.addPreProgressiveRenderer(new C(new t(false), 1));
        this.addProgressiveRenderer(new C(new t(true), 0));
        this.addProgressiveRenderer(new C(new S(), 0));
        this.addProgressiveRenderer(new C(new g(), 0));
        this.addProgressiveRenderer(new C(new q(), 0));
        this.addPostRenderer(new C(new t(true), 1));
        this.addPostRenderer(new C(new S(), 1));
        this.addPostRenderer(new C(new L()));
        this.labelRenderer = new DefaultTreeMapLabelRenderer();
        this.headerRenderer = new DefaultTreeMapHeaderRenderer();
        this.tooltipRenderer = new DefaultTreeMapTooltipRenderer();
        this.probingToolTip = new DefaultTreeMapToolTip(this);
        this.selectionToolTip = null;
        int n2 = 0;
        int n3 = 0;
        this.xRangeModel = new SimpleBoundedInterval(0.0, (double)n2, 0.0, (double)n2);
        this.yRangeModel = new SimpleBoundedInterval(0.0, (double)n3, 0.0, (double)n3);
        this.screenTransform = new SimpleTwoDScreenTransform((MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.xRangeModel, n2), (MutableOneDScreenTransform)new SimpleOneDScreenTransform((BoundedInterval)this.yRangeModel, n3, true, true), n2, n3, 1.0);
        this.i = new ScreenTransformRubberBand((TwoDScreenTransform)this.screenTransform);
        this.i.getRubberBand().addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(){

            public void selectionChanged(SingleSelectionEvent<Rectangle2D> event) {
                AbstractTreeMapView.this.repaint();
            }
        });
        new RangesScreenTransformCoordinator(this.xRangeModel, this.yRangeModel);
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                AbstractTreeMapView.this.b();
                AbstractTreeMapView.this.repaint();
            }
        });
        this.updateModelDimension();
        this.updateSize();
        this.xRangeModel.setMinimumExtent(10.0);
        this.yRangeModel.setMinimumExtent(10.0);
    }

    @Override
    public Headless<Color, Font> getHeadless() {
        return this.k;
    }

    @Override
    public boolean isUpdateModelDimension() {
        return this.g;
    }

    @Override
    public void setUpdateModelDimension(boolean updateModelDimension) {
        if (this.g != updateModelDimension) {
            this.g = updateModelDimension;
            this.updateModelDimension();
        }
    }

    @Override
    public TreeMapView.Progressive getProgressive() {
        if (this.getModel() != null && this.getModel().getSettings().getProgressive() != null) {
            return this.getModel().getSettings().getProgressive();
        }
        return this._progressive;
    }

    @Override
    public boolean isShowTiming() {
        return this._showTiming;
    }

    @Override
    public void setModel(TreeMapModel<N, Row, Column, Color, Font> model) {
        if (this._model != null) {
            this._model.removeListener(this.c);
            this._model.getProperties().removePropertiesListener(this.d);
            this._model.getFilter().removeFilterListener(this.e);
            this._model.getSearch().removeFilterListener(this.e);
            this._model.getSettings().getProperties().removePropertiesListener(this.f);
            this._model.getProbing().removeSingleSelectionListener(this.a);
            this._model.getSelection().removeSelectionListener(this.b);
        }
        this._model = model;
        this.b();
        model.addListener(this.c);
        model.getProperties().addPropertiesListener(this.d);
        model.getFilter().addFilterListener(this.e);
        model.getSearch().addFilterListener(this.e);
        model.getSettings().getProperties().addPropertiesListener(this.f);
        model.getProbing().addSingleSelectionListener(this.a);
        model.getSelection().addSelectionListener(this.b);
        this.updateModelDimension();
        this.updateSize();
    }

    @Override
    public TreeMapModel<N, Row, Column, Color, Font> getModel() {
        return this._model;
    }

    protected void addPreRenderer(TreeMapRenderer renderer) {
        this._preRenderers.add(renderer);
        this.repaint();
    }

    protected void addPreProgressiveRenderer(TreeMapRenderer renderer) {
        this._preProgressiveRenderers.add(renderer);
        this.a();
    }

    protected void addProgressiveRenderer(TreeMapRenderer renderer) {
        this._progressiveRenderers.add(renderer);
        this.a();
    }

    protected void addPostRenderer(TreeMapRenderer renderer) {
        this._postRenderers.add(renderer);
        this.repaint();
    }

    void a() {
        this.j = true;
        this.repaint();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.j = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b() {
        this.j = true;
        if (this._shapes != null) {
            Map<N, Shape> map = this._shapes;
            synchronized (map) {
                this._shapes.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape worldToScreen(N node) {
        Map<N, Shape> map = this._shapes;
        synchronized (map) {
            Shape shape = this._shapes.get(node);
            if (shape == null && node != null) {
                shape = this._model.getShape(node);
                shape = this.worldToScreen(shape);
                this._shapes.put(node, shape);
            }
            return shape;
        }
    }

    @Override
    public Shape worldToScreen(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            shape = this.worldToScreenPrecise(rectangle2D);
        } else if (shape instanceof TextShape) {
            AffineTransform affineTransform = ScreenTransformHelper.worldToScreen((OneDScreenTransform)this.screenTransform.getX(), (OneDScreenTransform)this.screenTransform.getY());
            shape = ((TextShape)shape).createTransformedShape(affineTransform);
        } else {
            AffineTransform affineTransform = ScreenTransformHelper.worldToScreen((OneDScreenTransform)this.screenTransform.getX(), (OneDScreenTransform)this.screenTransform.getY());
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape;
    }

    @Override
    public Shape getRenderedShape(N node) {
        return this._model.getSettings().getRendering().getRenderedShape(this, this._model, node, this.worldToScreen(node));
    }

    @Override
    public Rectangle2D getViewport() {
        Rectangle2D.Double double_ = Rectangle2D.Double.frameFromDiagonal((double)this.xRangeModel.getStart(), (double)this.yRangeModel.getStart(), (double)(this.xRangeModel.getStart() + this.xRangeModel.getExtent()), (double)(this.yRangeModel.getStart() + this.yRangeModel.getExtent()));
        return double_;
    }

    @Override
    public Rectangle2D getWorld() {
        Rectangle2D.Double double_ = Rectangle2D.Double.frameFromDiagonal((double)this.xRangeModel.getMinimum(), (double)this.yRangeModel.getMinimum(), (double)this.xRangeModel.getMaximum(), (double)this.yRangeModel.getMaximum());
        return double_;
    }

    @Override
    public double screenToWorldX(int x2) {
        return this.c().screenToWorld(x2);
    }

    @Override
    public double screenToWorldY(int y2) {
        return this.d().screenToWorld(y2);
    }

    @Override
    public int worldToScreenX(double x2) {
        return this.c().worldToScreen(x2);
    }

    @Override
    public int worldToScreenY(double y2) {
        return this.d().worldToScreen(y2);
    }

    @Override
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    private OneDScreenTransform c() {
        return this.screenTransform.getX();
    }

    private OneDScreenTransform d() {
        return this.screenTransform.getY();
    }

    @Override
    public Iterable<TreeMapRenderer> getPreRenderers() {
        return this._preRenderers;
    }

    @Override
    public Iterable<TreeMapRenderer> getPreProgressiveRenderers() {
        return this._preProgressiveRenderers;
    }

    @Override
    public Iterable<TreeMapRenderer> getProgressiveRenderers() {
        return this._progressiveRenderers;
    }

    @Override
    public Iterable<TreeMapRenderer> getPostRenderers() {
        return this._postRenderers;
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    @Override
    public N getNode(Point p2) {
        N n2;
        Shape shape;
        N n3;
        if (this._model != null && p2 != null && (n3 = this._model.getCurrentRoot()) != null && (shape = this.getRenderedShape(n3)) != null && this.contains(p2, shape) && (n2 = this.a(this._model, n3, p2)) != null && n2 != n3 && !this._model.getFilter().isFiltered(n2) && !this._model.getSearch().isFiltered(n2)) {
            return n2;
        }
        return null;
    }

    private N a(TreeMapModel<N, Row, Column, Color, Font> treeMapModel, N n2, Point point) {
        for (N n3 : treeMapModel.getChildren(n2)) {
            N n4;
            if (treeMapModel.getFilter().isFiltered(n3)) continue;
            Shape shape = this.getRenderedShape(n3);
            int n5 = treeMapModel.getLevel(n2) - treeMapModel.getLevel(treeMapModel.getCurrentRoot());
            Algorithm algorithm = treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(n2)).getAlgorithm();
            if (!treeMapModel.getSettings().getDepth().display(n5 + 1) || !algorithm.isCompatible(treeMapModel.getShape(n2))) continue;
            if (shape == null && !treeMapModel.hasNoChildren(n2)) {
                n4 = this.a(treeMapModel, n3, point);
                if (n4 == n3) continue;
                return n4;
            }
            if (this.contains(point, shape)) {
                return this.a(treeMapModel, n3, point);
            }
            if (treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(n2)).getAlgorithm().isChildContained()) continue;
            if (this.contains(point, shape)) {
                return n3;
            }
            n4 = this.a(treeMapModel, n3, point);
            if (n4 == n3) continue;
            return n4;
        }
        return n2;
    }

    @Override
    public boolean contains(Point p2, Shape shape) {
        if (shape instanceof TextShape) {
            return shape.getBounds2D().contains(p2.getX(), p2.getY());
        }
        return shape.contains((Point2D)new Point2D.Double(p2.getX(), p2.getY()));
    }

    @Override
    public List<N> getNodes(Rectangle rect) {
        if (this._model != null && rect != null) {
            ArrayList<N> arrayList = new ArrayList<N>();
            N n2 = this._model.getCurrentRoot();
            if (this.getRenderedShape(n2).intersects((Rectangle2D)rect)) {
                if (this._model.hasNoChildren(n2)) {
                    arrayList.add(n2);
                }
                this.a(this._model, n2, rect, arrayList);
            }
            return arrayList;
        }
        return null;
    }

    private N a(TreeMapModel<N, Row, Column, Color, Font> treeMapModel, N n2, Rectangle rectangle, List<N> list) {
        for (N n3 : treeMapModel.getChildren(n2)) {
            Shape shape = this.getRenderedShape(n3);
            if (shape == null || !shape.intersects((Rectangle2D)rectangle)) continue;
            if (treeMapModel.hasNoChildren(n3)) {
                list.add(n3);
            }
            this.a(treeMapModel, n3, rectangle, list);
        }
        return n2;
    }

    @Override
    public RubberBand getRubberBand() {
        return this.i;
    }

    @Override
    public Rectangle worldToScreenRectangle(Rectangle2D r2) {
        int n2 = (int)Math.round(this.screenTransform.getX().worldToScreenPrecise(r2.getMinX()));
        int n3 = (int)Math.round(this.screenTransform.getX().worldToScreenPrecise(r2.getMaxX()));
        int n4 = (int)Math.round(this.screenTransform.getY().worldToScreenPrecise(r2.getMinY()));
        int n5 = (int)Math.round(this.screenTransform.getY().worldToScreenPrecise(r2.getMaxY()));
        int n6 = n3 - n2;
        int n7 = n5 - n4;
        if (n6 < 0 || n7 < 0) {
            return new Rectangle(n2, n4, 0, 0);
        }
        return new Rectangle(n2, n4, n6, n7);
    }

    @Override
    public Rectangle2D worldToScreenPrecise(Rectangle2D r2) {
        double d2 = this.screenTransform.getX().worldToScreenPrecise(r2.getMinX());
        double d3 = this.screenTransform.getX().worldToScreenPrecise(r2.getMaxX());
        double d4 = this.screenTransform.getY().worldToScreenPrecise(r2.getMinY());
        double d5 = this.screenTransform.getY().worldToScreenPrecise(r2.getMaxY());
        double d6 = d3 - d2;
        double d7 = d5 - d4;
        if (d6 < 0.0 || d7 < 0.0) {
            return new Rectangle2D.Double(d2, d4, 0.0, 0.0);
        }
        return new Rectangle2D.Double(d2, d4, d6, d7);
    }

    @Override
    public float getZoomFactor() {
        float f2 = (float)(this.xRangeModel.getMaximumExtent() / this.xRangeModel.getExtent());
        float f3 = (float)(this.yRangeModel.getMaximumExtent() / this.yRangeModel.getExtent());
        return Math.min(f2, f3);
    }

    @Override
    public TreeMapLabelRenderer<C, N, Row, Column, Color, Font> getLabelRenderer() {
        return this.labelRenderer;
    }

    @Override
    public void setLabelRenderer(TreeMapLabelRenderer<C, N, Row, Column, Color, Font> renderer) {
        if (this.labelRenderer != renderer) {
            this.labelRenderer = renderer;
            this.repaint();
        }
    }

    @Override
    public TreeMapHeaderRenderer<N, Row, Column, Color, Font> getHeaderRenderer() {
        return this.headerRenderer;
    }

    @Override
    public void setHeaderRenderer(TreeMapHeaderRenderer<N, Row, Column, Color, Font> renderer) {
        if (this.headerRenderer != renderer) {
            this.headerRenderer = renderer;
            this.repaint();
        }
    }

    @Override
    public TreeMapTooltipRenderer<C, N, Row, Column, Color, Font> getTooltipRenderer() {
        return this.tooltipRenderer;
    }

    @Override
    public void setTooltipRenderer(TreeMapTooltipRenderer<C, N, Row, Column, Color, Font> renderer) {
        if (this.tooltipRenderer != renderer) {
            this.tooltipRenderer = renderer;
            this.repaint();
        }
    }

    @Override
    public TreeMapToolTip<N, Row, Column, Color, Font> getToolTip() {
        return this.probingToolTip;
    }

    @Override
    public void setToolTip(TreeMapToolTip<N, Row, Column, Color, Font> tooltip) {
        if (this.probingToolTip != tooltip) {
            this.probingToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public TreeMapToolTip<N, Row, Column, Color, Font> getSelectionToolTip() {
        return this.selectionToolTip;
    }

    @Override
    public void setSelectionToolTip(TreeMapToolTip<N, Row, Column, Color, Font> tooltip) {
        if (this.selectionToolTip != tooltip) {
            this.selectionToolTip = tooltip;
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        this.repaint(0L);
    }

    protected abstract void repaint(long var1);

    protected abstract void updateSize();

    @Override
    public boolean isSelectionMode() {
        return this.h;
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.h = value;
    }

    @Override
    public TwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Override
    public void drill(int x2, int y2) {
        TreeMapModel<Object, Row, Column, Color, Font> treeMapModel = this.getModel();
        N n2 = treeMapModel.getCurrentRoot();
        treeMapModel.getProbing().clearSelection();
        Point point = new Point(x2, y2);
        if (point != null) {
            ArrayList<N> arrayList = new ArrayList<N>();
            for (N n3 : treeMapModel.breadthFirstIterator(n2)) {
                if (!this.contains(point, this.getRenderedShape(n3))) continue;
                if (treeMapModel.hasNoChildren(n3)) {
                    Rectangle2D rectangle2D = this.getWorld();
                    this.zoom(false, rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
                    treeMapModel.setCurrentRoot(treeMapModel.getRoot());
                    break;
                }
                arrayList.add(n3);
                if (arrayList.size() <= 1) continue;
                Rectangle2D rectangle2D = this.getWorld();
                this.zoom(false, rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
                treeMapModel.setCurrentRoot(arrayList.get(1));
                break;
            }
        }
    }

    @Override
    public void drillDown() {
        TreeMapModel<Object, Row, Column, Color, Font> treeMapModel = this.getModel();
        Object object = treeMapModel.getProbing().getSelected();
        if (object != null) {
            while (treeMapModel.getParent(object) != treeMapModel.getCurrentRoot() && (object = treeMapModel.getParent(object)) != null) {
            }
        }
        if (object != null && !treeMapModel.hasNoChildren(object)) {
            MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
            MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
            this.zoom(false, mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
            treeMapModel.setCurrentRoot(object);
        }
    }

    @Override
    public void drillUp() {
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = this.getModel();
        treeMapModel.getProbing().clearSelection();
        if (!treeMapModel.isRoot(treeMapModel.getCurrentRoot())) {
            MutableBoundedInterval mutableBoundedInterval = this.getXRangeModel();
            MutableBoundedInterval mutableBoundedInterval2 = this.getYRangeModel();
            this.zoom(false, mutableBoundedInterval.getMinimum(), mutableBoundedInterval.getMaximum(), mutableBoundedInterval2.getMinimum(), mutableBoundedInterval2.getMaximum());
            N n2 = treeMapModel.getParent(treeMapModel.getCurrentRoot());
            treeMapModel.setCurrentRoot(n2);
        }
    }

    @Override
    public void zoomIn() {
        TreeMapModel<Object, Row, Column, Color, Font> treeMapModel = this.getModel();
        Object object = treeMapModel.getProbing().getSelected();
        if (object != null) {
            while (treeMapModel.getParent(object) != treeMapModel.getCurrentRoot() && (object = treeMapModel.getParent(object)) != null) {
            }
        }
        if (object != null && !treeMapModel.hasNoChildren(object)) {
            Rectangle2D rectangle2D = treeMapModel.getBounds(object);
            Rectangle2D rectangle2D2 = this.getWorld();
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D.getHeight();
            double d4 = d2 / rectangle2D2.getWidth();
            double d5 = d3 / rectangle2D2.getHeight();
            double d6 = Math.max(d4, d5);
            d2 = d6 * rectangle2D2.getWidth();
            d3 = d6 * rectangle2D2.getHeight();
            double d7 = rectangle2D.getX();
            double d8 = d7 + d2;
            double d9 = rectangle2D2.getMaxY() - (rectangle2D.getY() + d3);
            double d10 = rectangle2D2.getMaxY() - rectangle2D.getY();
            if (d7 < rectangle2D2.getMinX()) {
                d7 = rectangle2D2.getMinX();
                d8 = d7 + d2;
            }
            if (d8 > rectangle2D2.getMaxX()) {
                d7 = rectangle2D2.getMaxX() - d2;
                d8 = rectangle2D2.getMaxX();
            }
            if (d9 < rectangle2D2.getMinY()) {
                d9 = rectangle2D2.getMinY();
                d10 = d9 + d3;
            }
            if (d10 > rectangle2D2.getMaxY()) {
                d9 = rectangle2D2.getMaxY() - d3;
                d10 = rectangle2D2.getMaxY();
            }
            this.zoom(true, d7, d8, d9, d10);
        }
    }

    @Override
    public void zoomOut() {
        Rectangle2D rectangle2D = this.getWorld();
        this.zoom(true, rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY());
    }
}

