/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

class DockingUtility
implements IDockingConstants {
    static String DOCKABLE_INDICATOR = "Dockable.DOCKABLE_INDICATOR";

    private DockingUtility() {
    }

    public static IDockingPort getParentDockingPort(IDockable d) {
        return d == null ? null : DockingUtility.getParentDockingPort(d.getComponent());
    }

    public static IDockingPort getParentDockingPort(Component comp) {
        IDockingPort port;
        IDockingPort iDockingPort = port = comp == null ? null : (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, comp));
        if (port == null) {
            return null;
        }
        return port.isParentDockingPort(comp) ? port : null;
    }

    public static boolean isSubport(IDockingPort dockingPort) {
        return dockingPort == null ? false : SwingUtilities.getAncestorOfClass(IDockingPort.class, dockingPort.getComponent()) != null;
    }

    public static IDockingPort findDockingPort(Container container, Point location) {
        if (container == null || location == null) {
            return null;
        }
        Component deepestComponent = SwingUtilities.getDeepestComponentAt(container, location.x, location.y);
        if (deepestComponent == null) {
            return null;
        }
        if (deepestComponent instanceof IDockingPort) {
            return (IDockingPort)((Object)deepestComponent);
        }
        return (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, deepestComponent));
    }

    public static Component getDeepestComponentAt(int level, Component parent, int x, int y) {
        ++level;
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] componentArray = ((Container)parent).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c != null && c.isVisible()) {
                    Point loc = c.getLocation();
                    if ((c = c instanceof Container ? DockingUtility.getDeepestComponentAt(level, c, x - loc.x, y - loc.y) : c.getComponentAt(x - loc.x, y - loc.y)) != null) {
                        return c;
                    }
                }
                ++n2;
            }
        }
        return parent;
    }

    public static String translateRegionAxis(JSplitPane splitPane, String region) {
        boolean horizontal;
        if (splitPane == null || !DockingManager.isValidDockingRegion(region)) {
            return null;
        }
        boolean bl = horizontal = splitPane.getOrientation() == 1;
        if (horizontal) {
            if ("NORTH".equals(region)) {
                region = "WEST";
            } else if ("SOUTH".equals(region)) {
                region = "EAST";
            }
        } else if ("WEST".equals(region)) {
            region = "NORTH";
        } else if ("EAST".equals(region)) {
            region = "SOUTH";
        }
        return region;
    }

    public static String flipRegion(String region) {
        if (!DockingManager.isValidDockingRegion(region) || "CENTER".equals(region)) {
            return "CENTER";
        }
        if ("NORTH".equals(region)) {
            return "SOUTH";
        }
        if ("SOUTH".equals(region)) {
            return "NORTH";
        }
        if ("EAST".equals(region)) {
            return "WEST";
        }
        return "EAST";
    }

    public static boolean isAxisEquivalent(String region, String otherRegion) {
        if (!DockingManager.isValidDockingRegion(region) || !DockingManager.isValidDockingRegion(otherRegion)) {
            return false;
        }
        if (region.equals(otherRegion)) {
            return true;
        }
        if ("CENTER".equals(region)) {
            return false;
        }
        if ("NORTH".equals(region)) {
            return "WEST".equals(otherRegion);
        }
        if ("SOUTH".equals(region)) {
            return "EAST".equals(otherRegion);
        }
        if ("EAST".equals(region)) {
            return "SOUTH".equals(otherRegion);
        }
        if ("WEST".equals(region)) {
            return "NORTH".equals(otherRegion);
        }
        return false;
    }

    public static boolean isRegionTopLeft(String region) {
        return "NORTH".equals(region) || "WEST".equals(region);
    }

    public static String getRegion(int regionType) {
        switch (regionType) {
            case 2: {
                return "WEST";
            }
            case 4: {
                return "EAST";
            }
            case 1: {
                return "NORTH";
            }
            case 3: {
                return "SOUTH";
            }
            case 0: {
                return "CENTER";
            }
        }
        return "UNKNOWN";
    }

    public static int getPlacement(IDockable dockable) {
        int placement = -1;
        DockingState state = dockable == null ? null : DockingManager.getDockingState(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective());
        return state == null ? placement : state.getPlacement();
    }

    public static void setSplitProportion(IDockingPort port, float proportion) {
        if (port == null) {
            return;
        }
        JComponent comp = port.getDockedComponent();
        if (comp instanceof JSplitPane) {
            DockingUtility.setSplitDivider((JSplitPane)comp, proportion);
        }
    }

    public static void setSplitProportion(IDockable dockable, float proportion) {
        if (dockable == null) {
            return;
        }
        JComponent comp = dockable.getComponent();
        Container parent = comp.getParent();
        if (parent.getParent() instanceof JYTabbedPane) {
            parent = parent.getParent().getParent();
        } else if (parent instanceof JTabbedPane) {
            parent = parent.getParent();
        }
        if (!(parent instanceof IDockingPort)) {
            return;
        }
        Container grandParent = parent.getParent();
        if (grandParent instanceof JSplitPane) {
            DockingUtility.setSplitDivider((JSplitPane)grandParent, proportion);
        }
    }

    private static void setSplitDivider(final JSplitPane split, float proportion) {
        if (split == null) {
            return;
        }
        proportion = Math.max(0.0f, proportion);
        final float percent = Math.min(1.0f, proportion);
        int size = DockingUtility.getSplitPaneSize(split);
        if (split.isVisible() && size > 0 && EventQueue.isDispatchThread()) {
            split.setDividerLocation(proportion);
            split.validate();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockingUtility.setSplitDivider(split, percent);
            }
        });
    }

    private static int getSplitPaneSize(JSplitPane splitPane) {
        if (splitPane == null) {
            return 0;
        }
        boolean horiz = splitPane.getOrientation() == 1;
        return horiz ? splitPane.getWidth() : splitPane.getHeight();
    }

    public static IDockable getAncestorDockable(Component comp) {
        if (comp == null) {
            return null;
        }
        if (DockingUtility.isDockable(comp)) {
            return DockingManager.getDockable(comp);
        }
        Container parent = comp.getParent();
        while (parent != null && !(parent instanceof JRootPane)) {
            if (DockingUtility.isDockable(parent)) {
                return DockingManager.getDockable(parent);
            }
            parent = parent.getParent();
        }
        return null;
    }

    static boolean isDockable(Object obj) {
        if (obj instanceof IDockable) {
            return true;
        }
        if (obj instanceof JComponent) {
            return ((JComponent)obj).getClientProperty(DOCKABLE_INDICATOR) == Boolean.TRUE;
        }
        return false;
    }

    public static float calcSplitRatio(JSplitPane splitPane) {
        if (splitPane == null) {
            return 0.0f;
        }
        int size = splitPane.getOrientation() == 1 ? splitPane.getWidth() : splitPane.getHeight();
        int divLoc = splitPane.getDividerLocation();
        return size == 0 ? 0.0f : (float)divLoc / (float)(size - splitPane.getDividerSize());
    }

    public static int calcDividerLocation(JSplitPane splitPane, float splitRatio) {
        if (splitPane == null) {
            return 0;
        }
        int size = splitPane.getOrientation() == 1 ? splitPane.getWidth() : splitPane.getHeight();
        return (int)((float)(size - splitPane.getDividerSize()) * splitRatio);
    }

    public static Window getActiveWindow() {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return mgr.getActiveWindow();
    }

    public static Container getContentPane(Component c) {
        RootWindow rootWindow = RootWindow.getRootWindow(c);
        return rootWindow == null ? null : rootWindow.getContentPane();
    }

    public static Object getInstance(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getMethod("getInstance", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return DockingUtility.createInstance(className);
        }
    }

    public static Object createInstance(String className) {
        return DockingUtility.createInstance(className, null);
    }

    public static Object createInstance(String className, Class<?> superType) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            if (superType != null && !superType.isAssignableFrom(c)) {
                throw new ClassCastException("'" + c.getName() + "' is not a type of " + superType + ".");
            }
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isChanged(Object oldObj, Object newObj) {
        if (oldObj == newObj) {
            return false;
        }
        if (oldObj == null || newObj == null) {
            return true;
        }
        return !oldObj.equals(newObj);
    }

    public static String nodeToString(TreeNode layoutNode, int level, StringBuilder sb) {
        if (layoutNode == null) {
            return sb.toString();
        }
        int j = 0;
        while (j < level) {
            sb.append("  ");
            ++j;
        }
        sb.append(layoutNode);
        sb.append("\n");
        int i = 0;
        while (i < layoutNode.getChildCount()) {
            DockingUtility.nodeToString(layoutNode.getChildAt(i), level + 1, sb);
            ++i;
        }
        return sb.toString();
    }

    public static void printComponentTreeUp(int level, Container container) {
        ++level;
        int i = 0;
        while (i < level) {
            System.err.print("  ");
            ++i;
        }
        System.err.print(container.getClass());
        System.err.println();
        Container p = container.getParent();
        if (p != null) {
            DockingUtility.printComponentTreeUp(level, p);
        }
    }

    public static void printComponentTreeDown(int level, Container container) {
        ++level;
        int j = 0;
        while (j < level) {
            System.err.print("  ");
            ++j;
        }
        System.err.print(container.getClass());
        System.err.println();
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            DockingUtility.printComponentTreeDown(level, (Container)c);
            ++n2;
        }
    }
}

