/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DragGlassPane;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.DragOperation;
import de.javasoft.docking.controls.FloatPolicyManager;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class DragPipeline {
    private boolean open;
    private RootWindow[] windows;
    private DragGlassPane currentGlasspane;
    private DragOperation dragOperation;
    private DragWindow dragWindow;

    public void open(DragOperation dragOp) {
        this.dragOperation = dragOp;
        this.setCurrentDragOperation(dragOp);
        this.windows = RootWindow.getVisibleWindows();
        int i = 0;
        while (i < this.windows.length) {
            this.applyGlassPane(this.windows[i], this.createGlassPane());
            ++i;
        }
        dragOp.start();
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    private DragGlassPane createGlassPane() {
        DragGlassPane pane = new DragGlassPane();
        return pane;
    }

    private void applyGlassPane(RootWindow win, DragGlassPane pane) {
        pane.setRootWindow(win);
        pane.setCachedGlassPane(win.getGlassPane());
        win.setGlassPane(pane);
        pane.setVisible(true);
    }

    public DragOperation getDragOperation() {
        return this.dragOperation;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.clearDragWindow();
        int i = 0;
        while (i < this.windows.length) {
            Component cmp = this.windows[i].getGlassPane();
            if (cmp instanceof DragGlassPane) {
                DragGlassPane pane = (DragGlassPane)cmp;
                pane.setVisible(false);
                cmp = pane.getCachedGlassPane();
                this.windows[i].setGlassPane(cmp);
                this.windows[i] = null;
            }
            ++i;
        }
        this.setCurrentDragOperation(null);
        this.open = false;
    }

    public void processDragEvent(MouseEvent evt) {
        if (!this.open) {
            return;
        }
        this.processDragEventImpl(evt);
    }

    private void processDragEventImpl(MouseEvent evt) {
        Point locationOnScreen = new Point(evt.getPoint());
        SwingUtilities.convertPointToScreen(locationOnScreen, evt.getComponent());
        RootWindow rw = this.getTopmostWindow(locationOnScreen);
        boolean overWindow = rw != null;
        DragGlassPane newGlassPane = overWindow ? (DragGlassPane)rw.getGlassPane() : null;
        this.dragOperation.updateMouse(evt);
        this.dragOperation.setOverWindow(overWindow);
        evt.consume();
        if (newGlassPane == this.currentGlasspane) {
            if (this.currentGlasspane == null) {
                SwingUtilities.getRootPane(this.dragOperation.getDockableComponent()).setCursor(WidgetUtils.getDragCursor());
                this.drawDragWindow(null, this.dragOperation.getDragRect(true), locationOnScreen);
                return;
            }
            this.currentGlasspane.processDragEvent(this.dragOperation);
            this.clearDragWindow();
            return;
        }
        if (newGlassPane == null) {
            this.currentGlasspane.clear();
            this.currentGlasspane = null;
            return;
        }
        if (this.currentGlasspane == null) {
            this.currentGlasspane = newGlassPane;
            this.currentGlasspane.processDragEvent(this.dragOperation);
            return;
        }
        this.currentGlasspane.clear();
        this.currentGlasspane = newGlassPane;
        this.currentGlasspane.processDragEvent(this.dragOperation);
    }

    private RootWindow getTopmostWindow(Point screenLocation) {
        RootWindow w = null;
        RootWindow[] rootWindowArray = this.windows;
        int n = this.windows.length;
        int n2 = 0;
        while (n2 < n) {
            RootWindow rw = rootWindowArray[n2];
            Rectangle r = rw.getWindow().getBounds();
            if (r.contains(screenLocation) && rw.getGlassPane() instanceof DragGlassPane) {
                w = rw;
            }
            ++n2;
        }
        return w;
    }

    private void drawDragWindow(Graphics g, Rectangle rect, Point mouseScreenLocation) {
        Point p;
        boolean floatingAllowed = FloatPolicyManager.getInstance().isFloatingAllowed(this.dragOperation.getDockableReference());
        Point point = p = floatingAllowed ? new Point(rect.x, rect.y) : new Point(mouseScreenLocation.x - 1, mouseScreenLocation.y - 1);
        if (this.dragWindow == null) {
            int w = floatingAllowed ? rect.width : 3;
            int h = floatingAllowed ? rect.height : 3;
            JComponent dc = this.dragOperation.getDockableComponent();
            this.dragWindow = new DragWindow(SwingUtilities.getWindowAncestor(dc), dc, floatingAllowed);
            this.dragWindow.setBounds(p.x, p.y, w, h);
            this.dragWindow.setVisible(true);
        } else {
            this.dragWindow.setLocation(p.x, p.y);
        }
    }

    private void clearDragWindow() {
        if (this.dragWindow != null) {
            this.dragWindow.setVisible(false);
            this.dragWindow.dispose();
            this.dragWindow = null;
        }
    }

    private void setCurrentDragOperation(DragOperation operation) {
        DragOperation current = DragManager.getCurrentDragOperation();
        if (operation == current) {
            return;
        }
        IDockingPort srcPort = operation == null ? current.getSourcePort() : operation.getSourcePort();
        DragManager.setCurrentDragOperation(operation);
        if (srcPort instanceof Component) {
            srcPort.getComponent().repaint();
        }
    }

    private static class DragWindow
    extends JWindow {
        private static final long serialVersionUID = -8620509860787424418L;
        private BufferedImage image;
        private boolean floatingAllowed;

        public DragWindow(Window owner, JComponent c, boolean floatingAllowed) throws HeadlessException {
            super(owner);
            this.floatingAllowed = floatingAllowed;
            this.setCursor(floatingAllowed ? WidgetUtils.getDragCursor() : WidgetUtils.getStopCursor());
            if (floatingAllowed) {
                this.image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
                Graphics2D g = this.image.createGraphics();
                c.print(g);
                g.dispose();
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.floatingAllowed) {
                Graphics2D g2 = (Graphics2D)g;
                AlphaComposite composite = AlphaComposite.getInstance(3, 0.75f);
                g2.setComposite(composite);
                g2.drawImage((Image)this.image, 0, 0, null);
            }
        }
    }
}

