/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.ui.controls.DockingButton;
import de.javasoft.docking.ui.controls.DockingViewTitlebar;
import de.javasoft.docking.ui.controls.IDockingButtonFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.JYButtonIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.plaf.synth.SynthContext;

public class DockingButtonFactory
implements IDockingButtonFactory,
SwingConstants {
    private Icon minimizeIcon;
    private Icon minimizeIconActive;
    private Icon maximizeIcon;
    private Icon maximizeIconActive;
    private Icon floatIcon;
    private Icon floatIconActive;
    private Icon closeIcon;
    private Icon closeIconActive;

    @Override
    public DockingButton createMinimizeButton(Action action) {
        DockingButton b = new DockingButton(action){

            @Override
            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.minimizeIconActive : DockingButtonFactory.this.minimizeIcon;
                }
                return DockingButtonFactory.this.minimizeIcon;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setMinimizeButtonDefaults(this);
            }
        };
        b.setName("JYDocking.titlebar.MinimizeButton");
        this.setMinimizeButtonDefaults(b);
        return b;
    }

    private void setMinimizeButtonDefaults(DockingButton b) {
        this.minimizeIcon = this.createMinimizeIcon(b, false);
        this.minimizeIconActive = this.createMinimizeIcon(b, true);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYDocking.titlebar.minimizeButton.insets", (Component)b);
        if (insets != null) {
            b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        }
    }

    private Icon createMinimizeIcon(DockingButton b, final boolean active) {
        String uiKey = "JYDocking.titlebar." + (active ? "active." : "") + "minimizeButton.icon";
        return new JYButtonIcon(b, uiKey, 16, 16){

            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(DockingButtonFactory.this.getPaintColor(state, false));
                GeneralPath path = new GeneralPath();
                if (!state.isSet(SyntheticaState.State.SELECTED)) {
                    path.moveTo(3.0f, 10.0f);
                    path.lineTo(11.0f, 10.0f);
                    path.moveTo(3.0f, 11.0f);
                    path.lineTo(11.0f, 11.0f);
                } else {
                    path.moveTo(3.0f, 3.0f);
                    path.lineTo(11.0f, 3.0f);
                    path.moveTo(3.0f, 4.0f);
                    path.lineTo(11.0f, 4.0f);
                    path.lineTo(11.0f, 11.0f);
                    path.lineTo(3.0f, 11.0f);
                    path.lineTo(3.0f, 4.0f);
                    path.moveTo(7.0f, 4.0f);
                    path.lineTo(7.0f, 11.0f);
                    path.moveTo(7.0f, 7.0f);
                    path.lineTo(11.0f, 7.0f);
                }
                g2.draw(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (active ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public DockingButton createMaximizeButton(Action action) {
        DockingButton b = new DockingButton(action){

            @Override
            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.maximizeIconActive : DockingButtonFactory.this.maximizeIcon;
                }
                return DockingButtonFactory.this.maximizeIcon;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setMaximizeButtonDefaults(this);
            }
        };
        b.setName("JYDocking.titlebar.MaximizeButton");
        this.setMaximizeButtonDefaults(b);
        return b;
    }

    private void setMaximizeButtonDefaults(DockingButton b) {
        this.maximizeIcon = this.createMaximizeIcon(b, false);
        this.maximizeIconActive = this.createMaximizeIcon(b, true);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYDocking.titlebar.maximizeButton.insets", (Component)b);
        if (insets != null) {
            b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        }
    }

    private Icon createMaximizeIcon(DockingButton b, final boolean active) {
        String uiKey = "JYDocking.titlebar." + (active ? "active." : "") + "maximizeButton.icon";
        return new JYButtonIcon(b, uiKey, 16, 16){

            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(DockingButtonFactory.this.getPaintColor(state, false));
                GeneralPath path = new GeneralPath();
                if (!state.isSet(SyntheticaState.State.SELECTED)) {
                    path.moveTo(3.0f, 3.0f);
                    path.lineTo(11.0f, 3.0f);
                    path.moveTo(3.0f, 4.0f);
                    path.lineTo(11.0f, 4.0f);
                    path.lineTo(11.0f, 11.0f);
                    path.lineTo(3.0f, 11.0f);
                    path.lineTo(3.0f, 4.0f);
                } else {
                    path.moveTo(3.0f, 3.0f);
                    path.lineTo(11.0f, 3.0f);
                    path.moveTo(3.0f, 4.0f);
                    path.lineTo(11.0f, 4.0f);
                    path.lineTo(11.0f, 11.0f);
                    path.lineTo(3.0f, 11.0f);
                    path.lineTo(3.0f, 4.0f);
                    path.moveTo(7.0f, 4.0f);
                    path.lineTo(7.0f, 11.0f);
                    path.moveTo(7.0f, 7.0f);
                    path.lineTo(11.0f, 7.0f);
                }
                g2.draw(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (active ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public DockingButton createFloatButton(Action action) {
        DockingButton b = new DockingButton(action){

            @Override
            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.floatIconActive : DockingButtonFactory.this.floatIcon;
                }
                return DockingButtonFactory.this.floatIcon;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setFloatButtonDefaults(this);
            }
        };
        b.setName("JYDocking.titlebar.FloatButton");
        this.setFloatButtonDefaults(b);
        return b;
    }

    private void setFloatButtonDefaults(DockingButton b) {
        this.floatIcon = this.createFloatIcon(b, false);
        this.floatIconActive = this.createFloatIcon(b, true);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYDocking.titlebar.floatButton.insets", (Component)b);
        if (insets != null) {
            b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        }
    }

    private Icon createFloatIcon(DockingButton b, final boolean active) {
        String uiKey = "JYDocking.titlebar." + (active ? "active." : "") + "floatButton.icon";
        return new JYButtonIcon(b, uiKey, 16, 16){

            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(DockingButtonFactory.this.getPaintColor(state, false));
                GeneralPath path = new GeneralPath();
                if (!state.isSet(SyntheticaState.State.SELECTED)) {
                    path.moveTo(4.0f, 3.0f);
                    path.lineTo(9.0f, 3.0f);
                    path.lineTo(9.0f, 8.0f);
                    path.lineTo(4.0f, 3.0f);
                } else {
                    path.moveTo(5.0f, 11.0f);
                    path.lineTo(5.0f, 6.0f);
                    path.lineTo(10.0f, 11.0f);
                    path.lineTo(5.0f, 11.0f);
                }
                g2.draw(path);
                g2.fill(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (active ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public DockingButton createUndockButton(Action action) {
        DockingButton b = this.createFloatButton(action);
        b.setName("JYDocking.titlebar.UndockButton");
        return b;
    }

    @Override
    public DockingButton createCloseButton(Action action) {
        DockingButton b = new DockingButton(action){

            @Override
            public Icon getIcon() {
                if (this.getParent() instanceof DockingViewTitlebar) {
                    return ((DockingViewTitlebar)this.getParent()).isActive() ? DockingButtonFactory.this.closeIconActive : DockingButtonFactory.this.closeIcon;
                }
                return DockingButtonFactory.this.closeIcon;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                DockingButtonFactory.this.setCloseButtonDefaults(this);
            }
        };
        b.setName("JYDocking.titlebar.CloseButton");
        this.setCloseButtonDefaults(b);
        return b;
    }

    private void setCloseButtonDefaults(DockingButton b) {
        this.closeIcon = this.createCloseIcon(b, false);
        this.closeIconActive = this.createCloseIcon(b, true);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYDocking.titlebar.closeButton.insets", (Component)b);
        if (insets != null) {
            b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        }
    }

    private Icon createCloseIcon(DockingButton b, final boolean active) {
        String uiKey = "JYDocking.titlebar." + (active ? "active." : "") + "closeButton.icon";
        return new JYButtonIcon(b, uiKey, 16, 16){

            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(DockingButtonFactory.this.getPaintColor(state, true));
                GeneralPath path = new GeneralPath();
                path.moveTo(4.0f, 3.0f);
                path.lineTo(11.0f, 11.0f);
                path.moveTo(5.0f, 3.0f);
                path.lineTo(12.0f, 11.0f);
                path.moveTo(11.0f, 3.0f);
                path.lineTo(4.0f, 11.0f);
                path.moveTo(12.0f, 3.0f);
                path.lineTo(5.0f, 11.0f);
                g2.draw(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (active ? 0 : 1);
                return hash;
            }
        };
    }

    private Color getPaintColor(SyntheticaState state, boolean closeIcon) {
        Color color = new Color(0x505050);
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!state.isSet(SyntheticaState.State.PRESSED) && state.isSet(SyntheticaState.State.HOVER)) {
            color = closeIcon ? new Color(0xE00000) : new Color(0x888888);
        }
        return color;
    }
}

