/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.view;

import com.macrofocus.color.ColormapModel;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Row;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.geo.view.GeoRenderer;
import com.macrofocus.geo.view.GeoView;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class SimpleGeoRenderer
implements GeoRenderer {
    public BasicStroke normalStroke = new BasicStroke(1.0f);
    public BasicStroke borderStroke = new BasicStroke(0.5f);
    public BasicStroke probingStroke = new BasicStroke(1.5f);
    public BasicStroke selectionStroke = new BasicStroke(3.0f);
    public AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    public boolean fill = false;
    public boolean outline = true;
    public Color fillColor = Color.white;
    public Color color = Color.black;
    public Color selectionColor = Color.red;
    public Color selectionLabelColor = Color.red;
    public Color selectionFillColor = new Color(127, 0, 0);
    public Color probingColor = new Color(255, 102, 0);
    public Color probingLabelColor = new Color(193, 102, 0);
    public boolean drawLabelNormal = true;
    public boolean drawSelected = true;
    public boolean drawProbed = true;
    public boolean drawLabelSelected = true;
    public boolean drawLabelProbed = true;
    public boolean labelScaleFont = true;
    private Font font = new JLabel().getFont();
    CellRendererPane cellRendererPane = new CellRendererPane();
    EnhancedJLabel label = new EnhancedJLabel();

    @Override
    public void render(Graphics2D g2, GeoView view, GeoModel model) {
        Row row;
        Color color;
        Shape shape;
        Color color2;
        Object object;
        if (model.getColorColumn().isActive()) {
            Row row2;
            Column column = (Column)model.getColorColumn().getSelected();
            ColorMap colormap = model.getColormap(column);
            if (colormap != null) {
                if (this.fill) {
                    if (!this.outline) {
                        g2.setStroke(new BasicStroke(0.0f));
                    }
                    Composite composite = g2.getComposite();
                    g2.setComposite(this.alphaComposite);
                    for (int r = 0; r < model.getRowCount(); ++r) {
                        row2 = model.getRow(r);
                        Shape shape2 = view.getShape(model, r);
                        if (shape2 == null || !g2.getClipBounds().intersects(shape2.getBounds())) continue;
                        object = model.getTableModel().getValueAt(row2.getRow(), column.getColumn());
                        color2 = (Color)colormap.getColor(object).getNativeColor();
                        g2.setColor(color2);
                        g2.fill(shape2);
                    }
                    g2.setComposite(composite);
                }
                if (this.outline) {
                    for (int r = model.getRowCount() - 1; r >= 0; --r) {
                        Row row3 = model.getRow(r);
                        shape = view.getShape(model, r);
                        if (shape == null || !g2.getClipBounds().intersects(shape.getBounds())) continue;
                        Object object2 = model.getTableModel().getValueAt(row3.getRow(), column.getColumn());
                        color = (Color)colormap.getColor(object2).getNativeColor();
                        g2.setColor(this.getOutlineColor(color));
                        g2.draw(shape);
                    }
                }
            } else {
                MBoundedRangeModel rangeModel = model.getColorRangeModel(column);
                if (rangeModel != null) {
                    Double min = rangeModel.getValue();
                    Double max = rangeModel.getValue() + rangeModel.getExtent();
                    double range = max - min;
                    ColormapModel colors = (ColormapModel)model.getColormap().getSelected();
                    for (int r = 0; r < model.getRowCount(); ++r) {
                        Color color3;
                        Object object3;
                        Row row4 = model.getRow(r);
                        Shape shape3 = view.getShape(model, r);
                        if (shape3 == null || !g2.getClipBounds().intersects(shape3.getBounds()) || (object3 = model.getTableModel().getValueAt(row4.getRow(), column.getColumn())) == null || !(object3 instanceof Number) || min == null || max == null || Double.isNaN(((Number)object3).doubleValue()) || Double.isInfinite(((Number)object3).doubleValue())) continue;
                        double value = ((Number)object3).doubleValue();
                        if (range > 0.0) {
                            int entry = (int)((value - min) * (double)(colors.getColorCount() - 1) / range);
                            color3 = colors.getColor(entry);
                        } else {
                            color3 = Color.lightGray;
                        }
                        if (this.fill) {
                            g2.setColor(color3);
                            g2.fill(shape3);
                        }
                        g2.setColor(this.getOutlineColor(color3));
                        g2.draw(shape3);
                    }
                } else {
                    for (int r = 0; r < model.getRowCount(); ++r) {
                        row2 = model.getRow(r);
                        Shape shape4 = view.getShape(model, r);
                        if (shape4 == null || !g2.getClipBounds().intersects(shape4.getBounds())) continue;
                        object = model.getTableModel().getValueAt(row2.getRow(), column.getColumn());
                        if (!this.fill) continue;
                        g2.setColor(Color.lightGray);
                        g2.fill(shape4);
                        g2.draw(shape4);
                    }
                }
            }
        } else {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.borderStroke);
            for (int r = 0; r < model.getRowCount(); ++r) {
                Shape shape5;
                Row row5 = model.getRow(r);
                if (model.getProbing().isSelected((Object)row5) || model.getSelection().isSelected((Object)row5) || (shape5 = view.getShape(model, r)) == null || !g2.getClipBounds().intersects(shape5.getBounds())) continue;
                if (this.fill) {
                    g2.setColor(this.fillColor);
                    g2.fill(shape5);
                }
                g2.setColor(this.color);
                g2.draw(shape5);
            }
            g2.setStroke(oldStroke);
        }
        if (model.getImageColumn() != null && model.getImageColumn().isActive()) {
            Composite composite = g2.getComposite();
            g2.setComposite(this.alphaComposite);
            for (int r = 0; r < model.getRowCount(); ++r) {
                Row row6 = model.getRow(r);
                Rectangle bounds = view.getShape(model, r).getBounds();
                Image image = model.getImage(r);
                if (image == null) continue;
                g2.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, null);
            }
            g2.setComposite(composite);
        }
        if (this.drawLabelNormal) {
            RenderingHints renderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (model.getLabelColumn() != null && model.getLabelColumn().isActive()) {
                Column column = (Column)model.getLabelColumn().getSelected();
                for (int r = 0; r < model.getRowCount(); ++r) {
                    Column colorColumn;
                    ColorMap colormap;
                    Object object4;
                    Row row7 = model.getRow(r);
                    if (model.getSelection().isSelected((Object)row7) || model.getProbing().isSelected((Object)row7) || (shape = this.computeLabelBounds(view, model, r)) == null || !g2.getClipBounds().intersects(((RectangularShape)shape).getBounds()) || (object4 = model.getTableModel().getValueAt(row7.getRow(), column.getColumn())) == null) continue;
                    color = Color.white;
                    if (model.getColorColumn().isActive() && (colormap = model.getColormap(colorColumn = (Column)model.getColorColumn().getSelected())) != null) {
                        color = (Color)colormap.getColor(object4).getNativeColor();
                    }
                    this.drawlabel(g2, view, (Rectangle2D)shape, object4, color);
                }
            }
            g2.setRenderingHints(renderingHints);
        }
        if (this.drawSelected && model.getSelection().isActive()) {
            for (int r = 0; r < model.getRowCount(); ++r) {
                Object object5;
                row = model.getRow(r);
                if (!model.getSelection().isSelected((Object)row)) continue;
                Shape shape6 = view.getShape(model, r);
                if (shape6 != null && g2.getClipBounds().intersects(shape6.getBounds())) {
                    if (this.selectionFillColor != null) {
                        g2.setColor(this.selectionFillColor);
                        g2.fill(shape6);
                    } else if (model.getColorColumn().isActive()) {
                        Column column = (Column)model.getColorColumn().getSelected();
                        ColorMap colormap = model.getColormap(column);
                        if (this.fill && colormap != null) {
                            Composite composite = g2.getComposite();
                            g2.setComposite(this.alphaComposite);
                            object = model.getTableModel().getValueAt(row.getRow(), column.getColumn());
                            color2 = (Color)colormap.getColor(object).getNativeColor();
                            g2.setColor(color2);
                            g2.fill(shape6);
                            g2.setComposite(composite);
                        }
                    }
                    g2.setColor(this.selectionColor);
                    Stroke oldStroke = g2.getStroke();
                    g2.setStroke(this.selectionStroke);
                    g2.draw(shape6);
                    g2.setStroke(oldStroke);
                }
                if (!this.drawLabelProbed) continue;
                RenderingHints renderingHints = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Column column = (Column)model.getLabelColumn().getSelected();
                shape = this.computeLabelBounds(view, model, r);
                if (shape != null && g2.getClipBounds().intersects(((RectangularShape)shape).getBounds()) && (object5 = model.getTableModel().getValueAt(row.getRow(), column.getColumn())) != null) {
                    color = this.selectionLabelColor;
                    this.drawlabel(g2, view, (Rectangle2D)shape, object5, color);
                }
                g2.setRenderingHints(renderingHints);
            }
        }
        if (this.drawProbed && model.getProbing().isActive()) {
            for (int r = 0; r < model.getRowCount(); ++r) {
                Object object6;
                row = model.getRow(r);
                if (!model.getProbing().isSelected((Object)row)) continue;
                Shape shape7 = view.getShape(model, r);
                if (shape7 != null && g2.getClipBounds().intersects(shape7.getBounds())) {
                    g2.setColor(this.probingColor);
                    Stroke oldStroke = g2.getStroke();
                    g2.setStroke(this.probingStroke);
                    g2.draw(shape7);
                    g2.setStroke(oldStroke);
                }
                if (!this.drawLabelProbed) continue;
                RenderingHints renderingHints = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (model.getLabelColumn() == null || !model.getLabelColumn().isActive()) continue;
                Column column = (Column)model.getLabelColumn().getSelected();
                shape = this.computeLabelBounds(view, model, r);
                if (shape != null && g2.getClipBounds().intersects(((RectangularShape)shape).getBounds()) && (object6 = model.getTableModel().getValueAt(row.getRow(), column.getColumn())) != null) {
                    color = this.probingLabelColor;
                    this.drawlabel(g2, view, (Rectangle2D)shape, object6, color);
                }
                g2.setRenderingHints(renderingHints);
            }
        }
    }

    private Rectangle2D computeLabelBounds(GeoView view, GeoModel model, int r) {
        Rectangle2D shape;
        Geometry geometry = model.getGeometry(r);
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(0);
            for (int i = 1; i < multiPolygon.getNumGeometries(); ++i) {
                Polygon p = (Polygon)multiPolygon.getGeometryN(i);
                if (!(p.getArea() > polygon.getArea())) continue;
                polygon = p;
            }
            Envelope envelope = polygon.getEnvelopeInternal();
            LineString bisector = polygon.getFactory().createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
            Geometry intersection = bisector.intersection((Geometry)polygon);
            if (intersection instanceof MultiLineString) {
                envelope = intersection.getGeometryN(0).getEnvelopeInternal();
                for (int i = 1; i < intersection.getNumGeometries(); ++i) {
                    Envelope e = intersection.getGeometryN(i).getEnvelopeInternal();
                    if (!(e.getArea() > envelope.getArea())) continue;
                    envelope = e;
                }
            } else {
                envelope = intersection.getEnvelopeInternal();
            }
            Point2D p1 = view.modelToView(envelope.getMinX(), envelope.getMinY());
            Point2D p2 = view.modelToView(envelope.getMaxX(), envelope.getMaxY());
            shape = new Rectangle2D.Double(p1.getX(), p2.getY(), p2.getX() - p1.getX(), p1.getY() - p2.getY());
        } else {
            shape = view.getShape(model, r).getBounds2D();
        }
        return shape;
    }

    private void drawlabel(Graphics2D g2, GeoView view, Rectangle2D bounds, Object object, Color color) {
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.label.setRendering(EnhancedLabel.Rendering.Clip);
        this.label.setEffect(EnhancedLabel.Effect.Plain);
        this.label.setText(object.toString());
        this.label.setForeground(color);
        this.label.setForeground(Color.black);
        this.label.setFont(this.font);
        this.label.setSize(new Dimension((int)bounds.getWidth(), (int)bounds.getHeight()));
        Dimension size = this.label.getPreferredSize();
        float scaleX = (float)bounds.getWidth() / (float)size.getWidth();
        float scaleY = (float)bounds.getHeight() / (float)size.getHeight();
        float scale = Math.min(scaleX, scaleY);
        float fontSize = Math.max(9.0f, this.font.getSize2D() * scale / 1.5f);
        this.label.setFont(this.font.deriveFont(fontSize));
        this.cellRendererPane.paintComponent(g2, (Component)this.label, (Container)((Object)view), bounds.getBounds());
    }

    protected Color getOutlineColor(Color fillColor) {
        return fillColor;
    }

    public Color adjustLabelColor(Color foreground, Color background) {
        int brightness = (int)Math.sqrt((double)(background.getRed() * background.getRed()) * 0.241 + (double)(background.getGreen() * background.getGreen()) * 0.691 + (double)(background.getBlue() * background.getBlue()) * 0.068);
        if (brightness > 130) {
            return Color.darkGray;
        }
        return Color.lightGray;
    }
}

