/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.treemap.TreeMapPreferencesRoot;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.JavaCollectionFactory;
import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.resources.ResourceBundleResourcesModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.cli.CLArgsParser;
import com.macrofocus.util.cli.CLOption;
import com.macrofocus.util.cli.CLOptionDescriptor;
import com.macrofocus.util.cli.CLUtil;
import com.macrofocus.util.registration.RegisterAction;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.java.TreeMapResource;
import com.treemap.app.java.document.JavaTreeMapApplication;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.export.ExportGraphicsAction;
import com.treemap.swing.SwingTreeMap;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TreeMap {
    public static final ApplicationModel applicationModel = ApplicationModelFactory.TREEMAP_APP;
    public static boolean expertMode = false;
    private static Element fileSettings;
    private static Element commandLineSettings;
    private static Element configuration;
    private static Element layout;
    private static Element settings;
    private static Element defaultSettings;
    private static final int LANGUAGE_OPT = 108;
    private static final int EXPERT_OPT = 101;
    private static final int DISABLE_LOGGING_OPT = 103;
    private static final int HELP_OPT = 104;
    private static final int LF_OPT = 102;
    private static final int UI_SCALING_OPT = 117;
    private static final int GROUPBY_OPT = 97;
    private static final int LABEL_OPT = 98;
    private static final int BACKGROUND_OPT = 107;
    private static final int COLOR_OPT = 99;
    private static final int SIZE_OPT = 115;
    private static final int HEIGHT_OPT = 72;
    private static final int COLORMAP_OPT = 1;
    private static final int ALGORITHM_OPT = 2;
    private static final int AGGREGATION_OPT = 3;
    private static final int SCALE_OPT = 4;
    private static final int NESTING_OPT = 5;
    private static final int ORDERING_OPT = 6;
    private static final int DEPTH_OPT = 7;
    private static final int LABELING_OPT = 8;
    private static final int RENDERING_OPT = 9;
    private static final int DIMENSION_OPT = 100;
    private static final int DPI_OPT = 12;
    private static final int SETTINGS_OPT = 10;
    private static final int OUT_OPT = 11;
    private static final CLOptionDescriptor[] options;

    private static void findDefaultSettings(ResourcesModel resourcesModel) {
        String exeDir;
        String appDir;
        String userHome;
        File dir;
        ArrayList<File> defaultSettingsDirectories = new ArrayList<File>();
        String userDir = System.getProperty("user.dir");
        if (userDir != null && (dir = new File(userDir)).exists()) {
            defaultSettingsDirectories.add(dir);
        }
        if ((userHome = System.getProperty("user.home")) != null && (dir = new File(userHome)).exists()) {
            defaultSettingsDirectories.add(dir);
        }
        if ((appDir = System.getProperty("install4j.appDir")) != null && (dir = new File(appDir)).exists()) {
            defaultSettingsDirectories.add(dir);
        }
        if ((exeDir = System.getProperty("install4j.exeDir")) != null && (dir = new File(exeDir)).exists()) {
            defaultSettingsDirectories.add(dir);
        }
        RegisterAction registerAction = new RegisterAction(applicationModel);
        LicenseModel licenseModel = registerAction.loadLicenseData(resourcesModel.getPropertiesModel());
        Element settings = null;
        System.out.println("Looking for settings in " + String.valueOf(defaultSettingsDirectories));
        for (File directory : defaultSettingsDirectories) {
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("TreeMap.mtms");
                }
            });
            if (files == null || files.length <= 0) continue;
            Builder builder = new Builder(false);
            try {
                Element layout;
                System.out.println("Using settings from " + String.valueOf(files[0]));
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(files[0]));
                Document treemap = builder.build((InputStream)bis);
                settings = treemap.getRootElement();
                if (licenseModel.verify() != LicenseModel.State.Valid && settings.getLocalName().equals("TreeMap")) {
                    Attribute userAttribute = settings.getAttribute("user");
                    Attribute keyAttribute = settings.getAttribute("key");
                    if (userAttribute != null && keyAttribute != null) {
                        licenseModel = registerAction.loadLicenseData(userAttribute.getValue(), keyAttribute.getValue());
                    }
                }
                if ((layout = settings.getFirstChildElement("Layout")) == null) break;
                settings = new Element("TreeMap");
                settings.appendChild((Node)layout.copy());
                break;
            }
            catch (ParsingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        defaultSettings = settings;
    }

    public static ApplicationModel getApplicationModel() {
        return applicationModel;
    }

    public boolean isExpertMode() {
        return expertMode;
    }

    public Element getFileSettings() {
        return fileSettings;
    }

    private static Element getOrCreateCommandLineSettings() {
        if (commandLineSettings == null) {
            commandLineSettings = new Element("TreeMap");
        }
        return commandLineSettings;
    }

    private static Element getSettings() {
        Element treeMap;
        if (settings == null && (settings = (treeMap = TreeMap.getOrCreateCommandLineSettings()).getFirstChildElement("Settings")) == null) {
            settings = new Element("Settings");
            treeMap.appendChild((Node)settings);
        }
        return settings;
    }

    private static Element getLayoutFileSettings() {
        if (layout == null) {
            layout = new Element("Layout");
            TreeMap.getOrCreateCommandLineSettings().appendChild((Node)layout);
        }
        return layout;
    }

    private static Element getConfigurationFileSettings() {
        if (configuration == null) {
            configuration = new Element("Configuration");
            TreeMap.getOrCreateCommandLineSettings().appendChild((Node)configuration);
        }
        return configuration;
    }

    public static int getLfOpt() {
        return 102;
    }

    public static Element getDefaultSettings() {
        return defaultSettings;
    }

    public static void main(String[] args) {
        Locale locale;
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            System.err.println("Error: " + parser.getErrorString());
            return;
        }
        Vector clOptions = parser.getArguments();
        String filename = null;
        String language = null;
        boolean loggingOut = false;
        boolean loggingErr = false;
        String lf = null;
        String out = null;
        String expert = System.getProperty("expert");
        if (expert != null) {
            expertMode = Boolean.parseBoolean(expert);
        }
        String dpi = null;
        Double uiScaling = null;
        block34: for (int i = 0; i < clOptions.size(); ++i) {
            CLOption option = (CLOption)clOptions.get(i);
            switch (option.getId()) {
                case 0: {
                    filename = option.getArgument();
                    continue block34;
                }
                case 108: {
                    language = option.getArgument();
                    continue block34;
                }
                case 101: {
                    expertMode = true;
                    continue block34;
                }
                case 103: {
                    loggingOut = false;
                    loggingErr = false;
                    continue block34;
                }
                case 102: {
                    lf = option.getArgument();
                    continue block34;
                }
                case 117: {
                    uiScaling = Double.parseDouble(option.getArgument());
                    Double scaleFactor = uiScaling * 100.0;
                    UIManager.put("Synthetica.scaleFactor", scaleFactor);
                    continue block34;
                }
                case 97: {
                    Element groupByElement = new Element("GroupBy");
                    Element variable = new Element("Variable");
                    variable.addAttribute(new Attribute("name", option.getArgument()));
                    groupByElement.appendChild((Node)variable);
                    TreeMap.getConfigurationFileSettings().appendChild((Node)groupByElement);
                    continue block34;
                }
                case 115: {
                    Element sizeElement = new Element("Size");
                    sizeElement.addAttribute(new Attribute("variableName", option.getArgument()));
                    TreeMap.getConfigurationFileSettings().appendChild((Node)sizeElement);
                    continue block34;
                }
                case 99: {
                    Element colorElement = new Element("Color");
                    colorElement.addAttribute(new Attribute("variableName", option.getArgument()));
                    TreeMap.getConfigurationFileSettings().appendChild((Node)colorElement);
                    continue block34;
                }
                case 72: {
                    Element heightElement = new Element("Height");
                    heightElement.addAttribute(new Attribute("variableName", option.getArgument()));
                    TreeMap.getConfigurationFileSettings().appendChild((Node)heightElement);
                    continue block34;
                }
                case 98: {
                    Element labelElement = new Element("Label");
                    Element variable = new Element("Variable");
                    variable.addAttribute(new Attribute("name", option.getArgument()));
                    labelElement.appendChild((Node)variable);
                    TreeMap.getConfigurationFileSettings().appendChild((Node)labelElement);
                    continue block34;
                }
                case 107: {
                    Element backgroundElement = new Element("Background");
                    backgroundElement.addAttribute(new Attribute("variableName", option.getArgument()));
                    TreeMap.getConfigurationFileSettings().appendChild((Node)backgroundElement);
                    continue block34;
                }
                case 1: {
                    Element colormapElement = new Element("Colormap");
                    colormapElement.addAttribute(new Attribute("name", option.getArgument()));
                    configuration.appendChild((Node)colormapElement);
                    continue block34;
                }
                case 2: {
                    Element element = new Element("Algorithm");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 3: {
                    Element element = new Element("Aggregation");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 4: {
                    Element element = new Element("Scale");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 5: {
                    Element element = new Element("Nesting");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 6: {
                    Element element = new Element("Ordering");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 7: {
                    Element element = new Element("Depth");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 8: {
                    Element element = new Element("Labeling");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 9: {
                    Element element = new Element("Rendering");
                    element.addAttribute(new Attribute("name", option.getArgument()));
                    TreeMap.getLayoutFileSettings().appendChild((Node)element);
                    continue block34;
                }
                case 100: {
                    String dimension = option.getArgument();
                    Element treeMap = TreeMap.getSettings();
                    Attribute dimensionAttribute = treeMap.getAttribute("dimension");
                    if (dimensionAttribute == null) {
                        dimensionAttribute = new Attribute("dimension", dimension);
                        treeMap.addAttribute(dimensionAttribute);
                    } else {
                        dimensionAttribute.setValue(dimension);
                    }
                    Attribute dimensionFixedAttribute = treeMap.getAttribute("dimensionFixed");
                    if (dimensionFixedAttribute == null) {
                        dimensionFixedAttribute = new Attribute("dimensionFixed", "true");
                        treeMap.addAttribute(dimensionFixedAttribute);
                        continue block34;
                    }
                    dimensionAttribute.setValue("true");
                    continue block34;
                }
                case 12: {
                    dpi = option.getArgument();
                    continue block34;
                }
                case 10: {
                    Builder builder = new Builder(false);
                    try {
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(option.getArgument()));
                        Document treemap = builder.build((InputStream)bis);
                        fileSettings = treemap.getRootElement();
                    }
                    catch (ParsingException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block34;
                }
                case 11: {
                    out = option.getArgument();
                    continue block34;
                }
                case 104: {
                    CLUtil.printUsage((ApplicationModel)applicationModel, (CLOptionDescriptor[])options);
                }
            }
        }
        if (out != null) {
            System.setProperty("java.awt.headless", "true");
        }
        if (language != null) {
            locale = new Locale(language, Locale.getDefault().getCountry());
            Locale.setDefault(locale);
        } else {
            locale = Locale.getDefault();
        }
        ResourceBundleResourcesModel resourcesModel = new ResourceBundleResourcesModel(TreeMapPreferencesRoot.class, TreeMapResource.class, locale, TreeMapResource.getPreferences());
        PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        TreeMap.findDefaultSettings((ResourcesModel)resourcesModel);
        if (lf == null && propertiesModel != null) {
            lf = (String)propertiesModel.getValue("lookandfeel");
        }
        if (lf == null) {
            lf = "synthetica-whitevision";
        }
        if (out != null) {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.ERROR);
            File file = new File(filename);
            DataSource dataSource = DataSourceFactory.getDataSource((File)file);
            try {
                SwingTreeMap treeMap;
                Dimension dimension;
                Document xml;
                MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
                TreeMapDocument document = new TreeMapDocument(file.getName(), file.toURI().toURL().toExternalForm(), (DataFrame)dataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
                if (defaultSettings != null) {
                    JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, defaultSettings);
                }
                if ((xml = dataSource.getDocument(ApplicationModelFactory.TREEMAP)) != null) {
                    JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, xml.getRootElement());
                }
                if (fileSettings != null) {
                    JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, fileSettings);
                }
                if (commandLineSettings != null) {
                    JavaTreeMapApplication.loadSettings((CPFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), document, commandLineSettings);
                }
                if ((dimension = (treeMap = new SwingTreeMap(document.getTreeMapModel())).getModel().getSettings().getDimension()) == null || dimension.getWidth() <= 0.0 || dimension.getHeight() <= 0.0) {
                    treeMap.getModel().getSettings().setDimension(new Dimension(608, 569));
                }
                dimension = treeMap.getModel().getSettings().getDimension();
                ((JComponent)treeMap.getView().getNativeComponent()).setSize(dimension.width, dimension.height);
                treeMap.getView().waitUntilReady();
                ExportFormat<Component>[] formats = ExportGraphicsAction.getExportFormats(expertMode);
                File outputFile = new File(out);
                for (ExportFormat<Component> format : formats) {
                    if (!format.isValid() || !format.getFileFilter().accept(outputFile)) continue;
                    if (format instanceof AbstractRasterExportFormat) {
                        AbstractRasterExportFormat rasterExportFormat = (AbstractRasterExportFormat)format;
                        if (dpi != null) {
                            rasterExportFormat.setOutputDPI(Float.parseFloat(dpi));
                        }
                    }
                    format.save((ContentProvider)new DefaultContentProvider((Object)((Component)treeMap.getView().getNativeComponent())), outputFile);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.exit(1);
            }
            System.exit(0);
        } else {
            SwingTreeMapApplication application = TreeMap.init(lf);
            String fileUrl = filename;
            application.runAsyncUIThread(() -> {
                try {
                    application.start(fileUrl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static SwingTreeMapApplication init(String lf) {
        SwingTreeMapApplication application = new SwingTreeMapApplication(lf, expertMode);
        application.init();
        return application;
    }

    static {
        PluggableCollectionFactory.setInstance((CollectionFactory)new JavaCollectionFactory());
        System.setProperty("apple.awt.application.name", applicationModel.getName());
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", applicationModel.getName());
        System.setProperty("http.agent", applicationModel.getEdition() + " " + applicationModel.getName() + " v. " + applicationModel.getVersion());
        fileSettings = null;
        commandLineSettings = null;
        configuration = null;
        layout = null;
        settings = null;
        defaultSettings = null;
        options = new CLOptionDescriptor[]{new CLOptionDescriptor("language", 2, 108, "Set the default language"), new CLOptionDescriptor("expert", 8, 101, "Run TreeMap in expert mode"), new CLOptionDescriptor("disable-logging", 8, 103, "Disable logging window"), new CLOptionDescriptor("lf", 2, 102, "Set the look and feel"), new CLOptionDescriptor("uiscaling", 2, 117, "Scale the UI"), new CLOptionDescriptor("help", 8, 104, "Show the help"), new CLOptionDescriptor("label", 2, 98, "Set the variable to use for labeling"), new CLOptionDescriptor("background", 2, 107, "Set the variable to use as background"), new CLOptionDescriptor("groupby", 2, 97, "Set the variable to use to groupBy"), new CLOptionDescriptor("color", 2, 99, "Set the variable to use for coloring"), new CLOptionDescriptor("size", 2, 115, "Set the variable to use to display the size"), new CLOptionDescriptor("height", 2, 72, "Set the variable to use to display the height"), new CLOptionDescriptor("colormap", 2, 1, "Set the colormap to use"), new CLOptionDescriptor("algorithm", 2, 2, "Set the TreeMap algorithm to use"), new CLOptionDescriptor("aggregation", 2, 3, "Set the aggregation method to use"), new CLOptionDescriptor("scale", 2, 4, "Set the scaling method to use"), new CLOptionDescriptor("nesting", 2, 5, "Set the nesting method to use"), new CLOptionDescriptor("ordering", 2, 6, "Set the ordering method to use"), new CLOptionDescriptor("depth", 2, 7, "Set the depth scheme to use"), new CLOptionDescriptor("labeling", 2, 8, "Set the labeling method to use"), new CLOptionDescriptor("rendering", 2, 9, "Set the rendering method to use"), new CLOptionDescriptor("dimension", 2, 100, "Specify the dimension of the treemap (default is 608;569)"), new CLOptionDescriptor("dpi", 2, 12, "Specify the DPI of the ouptut treemap (default is 72)"), new CLOptionDescriptor("settings", 2, 10, "Load a particular settings file"), new CLOptionDescriptor("out", 2, 11, "Specify the output file")};
    }
}

