/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.jidesoft.swing.JideBoxLayout;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.format.CPFormat;
import com.macrofocus.interval.adapter.BoundedIntervalSpinnerModel;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.math.stat.Histogram;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.HistogramRangeSliderRenderer;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.util.math.histogram.GenedataHistogram;
import com.treemap.TreeMapField;
import com.treemap.app.swing.configuration.FilterPanel;
import com.treemap.app.swing.configuration.InnerFiltersPanel;
import com.treemap.app.swing.presentation.implementation.HistogramView;
import com.treemap.app.swing.v4.model.MTreeMapModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

class RangeSliderFilterPanel
extends FilterPanel {
    private final BoundedIntervalRangeSliderAdapter sliderModel;
    private final SimpleBoundedInterval interval;

    public RangeSliderFilterPanel(final InnerFiltersPanel filtersPanel, MTreeMapModel model, TreeMapField variable, int columnIndex) {
        Double max = model.getNumericMax(variable);
        Double min = model.getNumericMin(variable);
        this.interval = new SimpleBoundedInterval(min.doubleValue(), max - min, min.doubleValue(), max.doubleValue());
        this.interval.setMinimumExtent(-(max - min));
        this.sliderModel = new BoundedIntervalRangeSliderAdapter((MutableBoundedInterval)this.interval);
        double[] values = model.getNumericalValues(variable);
        this.sliderModel.setHistogram((Histogram)new GenedataHistogram(values));
        BoundedIntervalSpinnerModel leftSpinnerModel = new BoundedIntervalSpinnerModel((MutableBoundedInterval)this.interval, (Number)1.0, BoundedIntervalSpinnerModel.Type.StartValue);
        JSpinner leftSpinner = new JSpinner((SpinnerModel)leftSpinnerModel){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        JSpinner.NumberEditor leftEditor = new JSpinner.NumberEditor(leftSpinner);
        leftEditor.getTextField().setFocusLostBehavior(1);
        CPFormat format = model.getSettings().getFieldSettings(model.getTreeMapField(columnIndex)).getFormat();
        if (format != null && format.getNativeFormat() instanceof NumberFormat) {
            NumberFormatter num1 = new NumberFormatter((NumberFormat)format.getNativeFormat());
            DefaultFormatterFactory factory = new DefaultFormatterFactory(num1, num1, num1);
            leftEditor.getTextField().setFormatterFactory(factory);
        }
        leftEditor.getTextField().setFont(leftEditor.getTextField().getFont().deriveFont(0, 10.0f));
        RangeSliderFilterPanel.sizeSpinner((SpinnerNumberModel)leftSpinnerModel, leftEditor);
        leftSpinner.setEditor(leftEditor);
        BoundedIntervalSpinnerModel rightSpinnerModel = new BoundedIntervalSpinnerModel((MutableBoundedInterval)this.interval, (Number)1.0, BoundedIntervalSpinnerModel.Type.EndValue);
        JSpinner rightSpinner = new JSpinner((SpinnerModel)rightSpinnerModel){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        JSpinner.NumberEditor rightEditor = new JSpinner.NumberEditor(rightSpinner);
        if (format != null && format instanceof NumberFormat) {
            NumberFormatter num1 = new NumberFormatter((NumberFormat)format);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(num1, num1, num1);
            rightEditor.getTextField().setFormatterFactory(factory);
        }
        rightEditor.getTextField().setFont(rightEditor.getTextField().getFont().deriveFont(0, 10.0f));
        RangeSliderFilterPanel.sizeSpinner((SpinnerNumberModel)rightSpinnerModel, rightEditor);
        rightEditor.getTextField().setFocusLostBehavior(1);
        rightSpinner.setEditor(rightEditor);
        String sliderName = variable.getName();
        JLabel field = new JLabel(sliderName){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        field.setToolTipText(sliderName);
        field.setHorizontalAlignment(0);
        JPanel valuePanel = new JPanel((LayoutManager)new HorizontalProportionalLayoutManager());
        valuePanel.setLayout((LayoutManager)new JideBoxLayout((Container)valuePanel, 0, 2));
        valuePanel.add((Component)leftSpinner, "flexible");
        valuePanel.add((Component)field, "vary");
        valuePanel.add((Component)rightSpinner, "flexible");
        JRangeSlider rangeSlider = new JRangeSlider((RangeSliderModel)this.sliderModel, 0);
        rangeSlider.setOpaque(true);
        rangeSlider.setHistogramRenderer(new HistogramRangeSliderRenderer(){

            public Component getRangeSliderHistogramRendererComponent(JRangeSlider rangeSlider, Histogram histogram) {
                if (histogram != null) {
                    HistogramView view = new HistogramView(HistogramView.Orientation.HORIZONTAL);
                    view.setDoubleBuffered(false);
                    view.setHistogram(histogram);
                    view.setRangeModel((Interval)RangeSliderFilterPanel.this.interval);
                    return view;
                }
                return null;
            }
        });
        new SimpleRangeSliderController((SliderView)rangeSlider);
        this.sliderModel.addSliderListener(new RangeSliderListener(){

            public void sliderChanged(RangeSliderEvent e) {
                filtersPanel.applyFilters();
            }

            public void sliderScaleChanged(RangeSliderEvent e) {
            }
        });
        this.setLayout((LayoutManager)new JideBoxLayout((Container)((Object)this), 1));
        this.add(valuePanel, "fix");
        this.add((Component)rangeSlider, "flexible");
    }

    public void setFilter(double min, double max) {
        this.sliderModel.setValues((Object)this, min, max);
    }

    @Override
    public void reset() {
        this.sliderModel.reset((Object)this);
    }

    @Override
    public Boolean applyFilters(Object object) {
        if (object != null && object instanceof Number) {
            boolean filtered;
            double numericValue = ((Number)object).doubleValue();
            boolean bl = filtered = this.sliderModel != null && !this.sliderModel.isFullRange() && !Double.isNaN(numericValue);
            if (filtered) {
                filtered = !this.interval.isInverted() ? this.interval.getStart() > numericValue || this.interval.getEnd() < numericValue : this.interval.getStart() >= numericValue && this.interval.getEnd() <= numericValue;
            }
            return filtered;
        }
        return !this.sliderModel.isFullRange();
    }

    private static void sizeSpinner(SpinnerNumberModel model, JSpinner.NumberEditor editor) {
        try {
            String min = editor.getTextField().getFormatter().valueToString(model.getMinimum());
            String max = editor.getTextField().getFormatter().valueToString(model.getMaximum());
            String value = editor.getTextField().getFormatter().valueToString(model.getValue());
            JFormattedTextField ftf = new JFormattedTextField(){
                private int columnWidth;

                @Override
                protected int getColumnWidth() {
                    if (this.columnWidth == 0) {
                        FontMetrics metrics = this.getFontMetrics(this.getFont());
                        this.columnWidth = metrics.charWidth('1');
                    }
                    return this.columnWidth;
                }

                @Override
                public void setFont(Font f) {
                    super.setFont(f);
                    this.columnWidth = 0;
                }
            };
            ftf.setName("Spinner.formattedTextField");
            ftf.setFont(editor.getTextField().getFont());
            int columns = Math.max(min.length(), Math.max(max.length(), value.length()));
            ftf.setColumns(columns);
            Dimension size = ftf.getPreferredSize();
            Dimension maxSize = editor.getTextField().getPreferredSize();
            editor.getTextField().setPreferredSize(size);
            if (maxSize.width > size.width) {
                editor.getTextField().setMaximumSize(maxSize);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

