/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPColor;
import com.treemap.NoTreeMapField;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import org.web3d.x3d.jsail.Core.Scene;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.jsail.Core.head;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.Geometry3D.Box;
import org.web3d.x3d.jsail.Grouping.Group;
import org.web3d.x3d.jsail.Grouping.Transform;
import org.web3d.x3d.jsail.Navigation.Viewpoint;
import org.web3d.x3d.jsail.Shape.Appearance;
import org.web3d.x3d.jsail.Shape.Material;
import org.web3d.x3d.jsail.Shape.Shape;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Rendering.X3DGeometryNode;
import org.web3d.x3d.sai.Shape.X3DAppearanceNode;
import org.web3d.x3d.sai.Shape.X3DMaterialNode;

class X3DExportCommand
extends AbstractUICommand {
    private final float FLOOR_SIZE = 10.0f;
    private final float DEFAULT_HEIGHT = 1.0f;
    private final TreeMapModel treeMapModel;

    public X3DExportCommand(TreeMapModel treeMapModel) {
        super("Export 3D Model...");
        this.treeMapModel = treeMapModel;
        this.enabledProperty().setValue((Object)(treeMapModel != null ? 1 : 0));
    }

    public void execute(Object source) {
        float verticalScalingFactor;
        X3D x3dModel = new X3D();
        Scene scene = new Scene();
        Group group = new Group();
        scene.addChild((X3DChildNode)group);
        Object rootNode = this.treeMapModel.getRoot();
        Rectangle2D rootBounds = this.treeMapModel.getBounds(rootNode);
        float xMax = (float)rootBounds.getWidth();
        float yMax = (float)rootBounds.getHeight();
        float min = Math.min(xMax, yMax);
        Viewpoint viewpoint = new Viewpoint();
        viewpoint.setPosition(xMax / 2.0f, yMax / 2.0f, 1000.0f);
        viewpoint.setCenterOfRotation(xMax / 2.0f, yMax / 2.0f, 0.0f);
        scene.addChild((X3DChildNode)viewpoint);
        TreeMapField field = (TreeMapField)this.treeMapModel.getSettings().getHeightVariableSelection().getSelected();
        if (field instanceof NoTreeMapField) {
            verticalScalingFactor = 0.0f;
        } else {
            float maxHeight = this.treeMapModel.getNumericMax(field).floatValue();
            verticalScalingFactor = 1.0f / maxHeight * 10.0f * ((float)this.treeMapModel.getSettings().getMaximumHeight() * 2.0f);
        }
        for (Object node : this.treeMapModel.preorderEnumeration(this.treeMapModel.getRoot())) {
            Object value;
            if (!this.treeMapModel.hasNoChildren(node)) continue;
            Rectangle2D bounds = this.treeMapModel.getBounds(node);
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight();
            if (Float.isNaN(width) || Float.isNaN(height)) continue;
            float x = (float)bounds.getX();
            float y = (float)bounds.getY();
            float p1x = x - (float)rootBounds.getX();
            float p1y = yMax - y + (float)rootBounds.getY();
            float p2x = x + width - (float)rootBounds.getX();
            float p2y = yMax - y + (float)rootBounds.getY();
            float p3x = x + width - (float)rootBounds.getX();
            float p3y = yMax - (y + height) + (float)rootBounds.getY();
            float p4x = x - (float)rootBounds.getX();
            float p4y = yMax - (y + height) + (float)rootBounds.getY();
            Appearance appearance = new Appearance();
            CPColor color = this.treeMapModel.getColor(node);
            appearance.setMaterial((X3DMaterialNode)new Material().setDiffuseColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
            float size = 1.0f;
            if (!(field instanceof NoTreeMapField) && (value = field.getValue(node)) != null) {
                size = ((Number)value).floatValue();
                float maxHeight = this.treeMapModel.getNumericMax(field).floatValue();
                size = size / maxHeight * ((float)this.treeMapModel.getSettings().getMaximumHeight() * min);
            }
            Box geometry = new Box();
            float halfWidth = (p2x - p1x) / 2.0f;
            float halfHeight = (p1y - p4y) / 2.0f;
            float halfSize = size / 2.0f;
            geometry.setSize(p2x - p1x, p1y - p4y, size);
            group.addChild((X3DChildNode)new Transform().setTranslation(p1x + halfWidth, p4y + halfHeight, 0.0f + halfSize).addChild((X3DChildNode)new Shape().setAppearance((X3DAppearanceNode)appearance).setGeometry((X3DGeometryNode)geometry)));
        }
        x3dModel.setHead(new head().addMeta(new meta().setName("title").setContent("Forbes Global 2000 - 2025.x3d")).addMeta(new meta().setName("creator").setContent("Macrofocus TreeMap"))).setScene(scene);
        x3dModel.setProfile("Interchange");
        x3dModel.toFileX3D("/Users/luc/Forbes Global 2000 - 2025.x3d");
        x3dModel.toFileVRML97("/Users/luc/Forbes Global 2000 - 2025.wrl");
        x3dModel.toFileX3DOM("/Users/luc/Forbes Global 2000 - 2025.html");
    }
}

