/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.TabDelimitedFileFilter;
import com.macrofocus.util.swing.export.format.AbstractExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.export.DataExportFormatSettingsPanel;
import com.treemap.app.swing.document.export.DelimitedTableWriter;
import com.treemap.app.swing.document.export.ExportFormatProperties;
import com.treemap.app.swing.document.export.TableWriter;
import com.treemap.swing.crossplatform.ShapeShape;
import java.awt.Component;
import java.awt.Shape;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTWriter;

public class TabDelimitedExportFormat
extends AbstractExportFormat<TreeMapDocument> {
    final TabDelimitedFileFilter fileFilter = new TabDelimitedFileFilter();
    final ExportFormatProperties properties = new ExportFormatProperties();

    public boolean isValid() {
        return true;
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Component getSettingsPanel() {
        return new DataExportFormatSettingsPanel(this.properties).getMainPanel();
    }

    public void save(ContentProvider<TreeMapDocument> contentProvider, File file) throws IOException {
        TreeMapView view = (TreeMapView)contentProvider.getContent();
        TreeMapModel model = view.getModel();
        String delimiter = "\t";
        String newLine = "\n";
        DelimitedTableWriter writer = new DelimitedTableWriter(new FileWriter(file), model.getColumnCount(), "\t", "\n");
        TabDelimitedExportFormat.writeTable(model, writer, this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeTable(TreeMapModel model, TableWriter writer, ExportFormatProperties properties) throws IOException {
        if (((Boolean)properties.getProperty("path").getValue()).booleanValue()) {
            writer.writeColumnName("Path", true);
        }
        if (((Boolean)properties.getProperty("includeIndentLevel").getValue()).booleanValue()) {
            writer.writeColumnName("Indent", true);
        }
        if (((Boolean)properties.getProperty("parentChildIndices").getValue()).booleanValue()) {
            writer.writeColumnName("Parent", true);
            writer.writeColumnName("Index", true);
        }
        if (((Boolean)properties.getProperty("includeColors").getValue()).booleanValue()) {
            writer.writeColumnName("Color", true);
        }
        if (((Boolean)properties.getProperty("includeSizes").getValue()).booleanValue()) {
            writer.writeColumnName("Size", true);
        }
        if (((Boolean)properties.getProperty("includeShapes").getValue()).booleanValue()) {
            writer.writeColumnName("Shape", true);
        }
        for (int column = 0; column < model.getColumnCount(); ++column) {
            String value = model.getColumnName((Object)column);
            writer.writeColumnName(value, column < model.getColumnCount() - 1);
        }
        writer.nextRow();
        if (((Boolean)properties.getProperty("types").getValue()).booleanValue()) {
            if (((Boolean)properties.getProperty("path").getValue()).booleanValue()) {
                writer.writeType("StringPath[delimiter=.]", true);
            }
            if (((Boolean)properties.getProperty("includeIndentLevel").getValue()).booleanValue()) {
                writer.writeType("Integer", true);
            }
            if (((Boolean)properties.getProperty("parentChildIndices").getValue()).booleanValue()) {
                writer.writeType("Integer", true);
                writer.writeType("Integer", true);
            }
            if (((Boolean)properties.getProperty("includeColors").getValue()).booleanValue()) {
                writer.writeType("Color", true);
            }
            if (((Boolean)properties.getProperty("includeSizes").getValue()).booleanValue()) {
                writer.writeType("Double", true);
            }
            if (((Boolean)properties.getProperty("includeShapes").getValue()).booleanValue()) {
                writer.writeType("Geometry", true);
            }
            DefaultTypemapModel typemapModel = new DefaultTypemapModel();
            for (int column = 0; column < model.getColumnCount(); ++column) {
                writer.writeType(typemapModel.getType(model.getColumnClass((Object)column)), column < model.getColumnCount() - 1);
            }
            writer.nextRow();
        }
        HashMap indices = new HashMap();
        int nextIndex = 1;
        HashMap<ComparableArray, Integer> pathIndex = new HashMap<ComparableArray, Integer>();
        HashMap<ComparableArray, Integer> nextPathIndex = new HashMap<ComparableArray, Integer>();
        for (Object node : model.preorderEnumeration(model.getCurrentRoot())) {
            if (model.isRoot(node)) continue;
            int depth = model.getLevel(node) - model.getLevel(model.getCurrentRoot());
            if (!model.getSettings().getDepth().display(depth) || model.getSettings().isHideFilterResults().booleanValue() && model.getFilter().isFiltered(node) || model.getSettings().isHideSearchResults().booleanValue() && model.getSearch().isFiltered(node) || ((Boolean)properties.getProperty("onlyLeafNodes").getValue()).booleanValue() && !model.hasNoChildren(node)) continue;
            if (((Boolean)properties.getProperty("path").getValue()).booleanValue()) {
                String[] array;
                Object leaf;
                if (((Boolean)properties.getProperty("pathText").getValue()).booleanValue()) {
                    try {
                        ArrayList<String> path = new ArrayList<String>();
                        leaf = node;
                        do {
                            path.add(0, model.getLabelName(leaf));
                        } while ((leaf = model.getParent(leaf)) != null);
                        array = new String[path.size() - 2];
                        for (int i = 1; i < path.size() - 1; ++i) {
                            String s;
                            array[i - 1] = s = (String)path.get(i);
                        }
                        writer.writeCell(array);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        writer.nextColumn(true);
                    }
                } else {
                    try {
                        ArrayList<String> path = new ArrayList<String>();
                        leaf = node;
                        do {
                            path.add(0, model.getLabelName(leaf));
                        } while ((leaf = model.getParent(leaf)) != null);
                        array = new String[path.size() - 2];
                        for (int i = 1; i < path.size() - 1; ++i) {
                            int index;
                            ComparableArray key = new ComparableArray(path.subList(1, i + 1));
                            if (pathIndex.containsKey(key)) {
                                index = (Integer)pathIndex.get(key);
                            } else {
                                ComparableArray parentKey = new ComparableArray(path.subList(1, i));
                                if (nextPathIndex.containsKey(parentKey)) {
                                    index = (Integer)nextPathIndex.get(parentKey);
                                    nextPathIndex.put(parentKey, index + 1);
                                } else {
                                    index = 1;
                                    nextPathIndex.put(parentKey, index + 1);
                                }
                                pathIndex.put(key, index);
                            }
                            array[i - 1] = Integer.toString(index);
                        }
                        writer.writeCell(array);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        writer.nextColumn(true);
                    }
                }
            }
            if (((Boolean)properties.getProperty("includeIndentLevel").getValue()).booleanValue()) {
                try {
                    writer.writeCell(model.getLevel(node));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
            }
            if (((Boolean)properties.getProperty("parentChildIndices").getValue()).booleanValue()) {
                try {
                    indices.put(node, nextIndex);
                    ++nextIndex;
                    Integer parentIndex = (Integer)indices.get(model.getParent(node));
                    writer.writeCell(parentIndex != null ? parentIndex : 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
                try {
                    int index = nextIndex;
                    writer.writeCell(index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
            }
            if (((Boolean)properties.getProperty("includeColors").getValue()).booleanValue()) {
                try {
                    writer.writeCell(model.getColor(node).toHTMLColor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
            }
            if (((Boolean)properties.getProperty("includeSizes").getValue()).booleanValue()) {
                try {
                    double v = model.getSize(node) / model.getSumSize(model.getParent(node));
                    if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                        writer.writeCell(v);
                    } else {
                        writer.writeCell(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
            }
            if (((Boolean)properties.getProperty("includeShapes").getValue()).booleanValue()) {
                try {
                    com.macrofocus.geom.Shape shape = model.getShape(node);
                    if (shape != null) {
                        Geometry geometry = ShapeReader.read((Shape)new ShapeShape(shape), (double)0.0, (GeometryFactory)new GeometryFactory());
                        WKTWriter wkt = new WKTWriter();
                        String value = wkt.write(geometry);
                        writer.writeCell(value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    writer.nextColumn(true);
                }
            }
            for (int column = 0; column < model.getColumnCount(); ++column) {
                try {
                    TreeMapField treeMapField = model.getTreeMapField(column);
                    Object value = (Boolean)properties.getProperty("formatValues").getValue() != false ? model.getStringValue(node, treeMapField, model.getSettings().getFieldSettings(treeMapField)) : (model.hasNoChildren(node) ? model.getValueAt(node, (Object)column) : model.getAggregateValue(node, treeMapField));
                    writer.writeCell(value);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        writer.nextColumn(column < model.getColumnCount() - 1);
                        throw throwable;
                    }
                    writer.nextColumn(column < model.getColumnCount() - 1);
                    continue;
                }
                writer.nextColumn(column < model.getColumnCount() - 1);
                continue;
            }
            writer.nextRow();
        }
        writer.close();
    }

    private static class ComparableArray {
        String[] array;

        private ComparableArray(List<String> list) {
            this.array = list.toArray(new String[list.size()]);
        }

        private ComparableArray(String[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparableArray that = (ComparableArray)o;
            return Arrays.equals(this.array, that.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

