/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.action;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.resources.ResourcesModel;
import com.treemap.TreeMapModel;
import com.treemap.swing.SwingTreeMapView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class DrillDownAction<N, Row, Column>
extends AbstractAction {
    private final SwingTreeMapView<N, Row, Column> view;

    public DrillDownAction(SwingTreeMapView<N, Row, Column> view) {
        this(view, null);
    }

    private DrillDownAction(SwingTreeMapView<N, Row, Column> view, ResourcesModel resourcesModel) {
        super("Drill Down");
        URL url;
        this.view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
        if (resourcesModel != null && (url = resourcesModel.getUrl("Down16.gif")) != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeMapModel model = this.view.getModel();
        Object root = model.getCurrentRoot();
        model.getProbing().clearSelection();
        Point location = this.view.getNativeComponent().getMousePosition();
        if (location != null) {
            ArrayList v = new ArrayList();
            for (Object treeMapNode : model.breadthFirstIterator(root)) {
                Shape renderedShape = this.view.getRenderedShape(treeMapNode);
                if (renderedShape == null || !renderedShape.contains((Point2D)new Point2D.Double((double)location.x, (double)location.y))) continue;
                if (model.hasNoChildren(treeMapNode)) {
                    MutableBoundedInterval xRange = this.view.getXRangeModel();
                    MutableBoundedInterval yRange = this.view.getYRangeModel();
                    this.view.zoom(false, xRange.getMinimum(), xRange.getMaximum(), yRange.getMinimum(), yRange.getMaximum());
                    model.setCurrentRoot(model.getRoot());
                    break;
                }
                v.add(treeMapNode);
                if (v.size() <= 1) continue;
                MutableBoundedInterval xRange = this.view.getXRangeModel();
                MutableBoundedInterval yRange = this.view.getYRangeModel();
                this.view.zoom(false, xRange.getMinimum(), xRange.getMaximum(), yRange.getMinimum(), yRange.getMaximum());
                model.setCurrentRoot(v.get(1));
                break;
            }
        }
    }
}

