/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class BubbleAlgorithm
extends AbstractAlgorithm {
    public static final boolean DEBUG = false;
    public static final int UNASSIGNED = -1;
    public static final int ASSIGNED = Integer.MAX_VALUE;
    public static final int CIRCULAR_LAYOUT = 1;
    public static final int RECTANGULAR_LAYOUT = 2;
    protected final int NORTH = 0;
    protected final int NORTHEAST = 1;
    protected final int EAST = 2;
    protected final int SOUTHEAST = 3;
    protected final int SOUTH = 4;
    protected final int SOUTHWEST = 5;
    protected final int WEST = 6;
    protected final int NORTHWEST = 7;
    protected int[] origSizes;
    protected Rectangle origBox;
    protected double origiar;
    protected int[][] idGrid = null;
    protected int numCols = 0;
    protected int numRows = 0;
    protected Rectangle box;
    protected List<Point[]> idList;
    protected Vector nextList;
    protected int layoutType = 1;

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        return false;
    }

    public BubbleAlgorithm(int[] sizes, double iar, Rectangle box) {
        this.origSizes = sizes;
        this.origBox = box;
        this.origiar = iar;
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    public void setLayoutType(int layout) {
        this.layoutType = layout;
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public List<Point[]> bubbleMapLayout() {
        int i;
        int area = this.computeSize(this.origSizes);
        double ar = this.computeAspectRatio(this.origBox) / this.origiar;
        this.numRows = (int)Math.ceil(Math.sqrt((double)area / ar));
        this.numCols = (int)Math.ceil((double)area / (double)this.numRows);
        this.box = new Rectangle(this.origBox.x, this.origBox.y, this.numCols, this.numRows);
        BubbleAlgorithm.debugPrintln("Orig box = " + String.valueOf(this.origBox) + ", New Box = " + String.valueOf(this.box));
        BubbleAlgorithm.debugPrintln("rows=" + this.numRows + ", cols=" + this.numCols);
        this.idGrid = new int[this.numRows][this.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.idGrid[i][j] = -1;
            }
        }
        this.idList = new ArrayList<Point[]>();
        this.nextList = new Vector();
        for (i = 0; i < this.origSizes.length; ++i) {
            Point[] pts = this.fill(i, this.origSizes[i]);
            this.idList.add(pts);
        }
        int element = 0;
        BubbleAlgorithm.debugPrintln("");
        for (Point[] pts : this.idList) {
            BubbleAlgorithm.debugPrintln("Size[" + element + "] = " + pts.length);
            for (i = 0; i < pts.length; ++i) {
                BubbleAlgorithm.debugPrintln("pt[" + i + "] = " + String.valueOf(pts[i]));
            }
            ++element;
        }
        return this.idList;
    }

    Point[] fill(int id, int size) {
        Point pt = null;
        BubbleAlgorithm.debugPrintln("A: id=" + id + ", size=" + size);
        block0: for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                if (this.idGrid[row][col] >= id) continue;
                pt = new Point(col, row);
                break block0;
            }
        }
        this.idGrid[pt.y][pt.x] = id;
        this.nextList.clear();
        this.insert(this.nextList, pt, pt);
        Point[] pts = new Point[size];
        this.fillRecurse(id, size, pts, pt);
        return pts;
    }

    void fillRecurse(int id, int size, Point[] pts, Point startpt) {
        Point pt;
        block27: {
            pt = null;
            if (size == 0) {
                return;
            }
            BubbleAlgorithm.debugPrintln("B: id=" + id + ", size=" + size + ", startpt=" + String.valueOf(startpt));
            try {
                pt = (Point)this.nextList.get(0);
                this.nextList.remove(0);
            }
            catch (Exception e) {
                for (int row = 0; row < this.numRows; ++row) {
                    for (int col = 0; col < this.numCols; ++col) {
                        if (this.idGrid[row][col] >= id) continue;
                        pt = new Point(col, row);
                    }
                }
                if (pt != null) break block27;
                System.out.println("ERROR - can't find space for point");
            }
        }
        pts[--size] = pt;
        this.idGrid[pt.y][pt.x] = Integer.MAX_VALUE;
        if (size > 0) {
            try {
                if (this.idGrid[pt.y][pt.x + 1] < id) {
                    this.idGrid[pt.y][pt.x + 1] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x + 1, pt.y));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y + 1][pt.x] < id) {
                    this.idGrid[pt.y + 1][pt.x] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x, pt.y + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y][pt.x - 1] < id) {
                    this.idGrid[pt.y][pt.x - 1] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x - 1, pt.y));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y + 1][pt.x - 1] < id) {
                    this.idGrid[pt.y + 1][pt.x - 1] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x - 1, pt.y + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y + 1][pt.x + 1] < id) {
                    this.idGrid[pt.y + 1][pt.x + 1] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x + 1, pt.y + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y - 1][pt.x] < id) {
                    this.idGrid[pt.y - 1][pt.x] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x, pt.y - 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.idGrid[pt.y - 1][pt.x + 1] < id) {
                    this.idGrid[pt.y - 1][pt.x + 1] = id;
                    this.insert(this.nextList, startpt, new Point(pt.x + 1, pt.y - 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fillRecurse(id, size, pts, startpt);
        }
    }

    void insert(Vector nextList, Point startpt, Point pt) {
        int index = 0;
        block0 : switch (this.layoutType) {
            case 1: {
                int refd = (pt.x - startpt.x) * (pt.x - startpt.x) + (pt.y - startpt.y) * (pt.y - startpt.y);
                for (Point p : nextList) {
                    int d = (p.x - startpt.x) * (p.x - startpt.x) + (p.y - startpt.y) * (p.y - startpt.y);
                    if (refd < d) break block0;
                    ++index;
                }
                break;
            }
            case 2: {
                index = nextList.size();
            }
        }
        nextList.add(index, pt);
    }

    public List<Point[]> getResult() {
        return this.idList;
    }

    public Rectangle getResultBox() {
        return this.box;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector getBoundary(int index) {
        int direction;
        Point startPt;
        int i;
        int nextDirection = 0;
        Vector<Point> boundary = new Vector<Point>();
        Point newPt = null;
        boolean first = true;
        if (this.idList == null) {
            BubbleAlgorithm.debugPrintln("Layout hasn't been computed yet");
            return boundary;
        }
        for (int col = 0; col < this.numCols; ++col) {
            for (int row = 0; row < this.numRows; ++row) {
                this.idGrid[row][col] = -1;
            }
        }
        Point[] pts = this.idList.get(index);
        for (i = 0; i < pts.length; ++i) {
            this.idGrid[pts[i].y][pts[i].x] = Integer.MAX_VALUE;
        }
        Point pt = startPt = pts[0];
        for (direction = 0; direction < 8 && !this.hasNeighbor(pt, direction); ++direction) {
        }
        BubbleAlgorithm.debugPrintln("Building boundary: startpt = " + String.valueOf(startPt));
        do {
            BubbleAlgorithm.debugPrintln("pt = " + String.valueOf(pt) + ", direction = " + direction);
            boolean missedNeighbor = false;
            Point nextPt = null;
            block15: for (i = 0; i < 9; ++i) {
                BubbleAlgorithm.debugPrintln("searching direction[" + i + "] = " + direction);
                switch (direction) {
                    case 0: {
                        if (!this.hasNeighbor(pt, 0)) {
                            if (first) {
                                first = false;
                                boundary.add(new Point(pt.x, pt.y));
                                BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            }
                            newPt = new Point(pt.x + 1, pt.y);
                            boundary.add(newPt);
                            BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            missedNeighbor = true;
                            break;
                        }
                        if (!missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x, pt.y - 1);
                        nextDirection = 6;
                        break block15;
                    }
                    case 1: {
                        if (!this.hasNeighbor(pt, 1) || !missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x + 1, pt.y - 1);
                        nextDirection = 6;
                        break block15;
                    }
                    case 2: {
                        if (!this.hasNeighbor(pt, 2)) {
                            if (first) {
                                first = false;
                                boundary.add(new Point(pt.x + 1, pt.y));
                                BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            }
                            newPt = new Point(pt.x + 1, pt.y + 1);
                            boundary.add(newPt);
                            BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            missedNeighbor = true;
                            break;
                        }
                        if (!missedNeighbor) break;
                        nextPt = new Point(pt.x + 1, pt.y);
                        nextDirection = 0;
                        break block15;
                    }
                    case 3: {
                        if (!this.hasNeighbor(pt, 3) || !missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x + 1, pt.y + 1);
                        nextDirection = 0;
                        break block15;
                    }
                    case 4: {
                        if (!this.hasNeighbor(pt, 4)) {
                            if (first) {
                                first = false;
                                boundary.add(new Point(pt.x + 1, pt.y + 1));
                                BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            }
                            newPt = new Point(pt.x, pt.y + 1);
                            boundary.add(newPt);
                            BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            missedNeighbor = true;
                            break;
                        }
                        if (!missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x, pt.y + 1);
                        nextDirection = 2;
                        break block15;
                    }
                    case 5: {
                        if (!this.hasNeighbor(pt, 5) || !missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x - 1, pt.y + 1);
                        nextDirection = 2;
                        break block15;
                    }
                    case 6: {
                        if (!this.hasNeighbor(pt, 6)) {
                            if (first) {
                                first = false;
                                boundary.add(new Point(pt.x, pt.y + 1));
                                BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            }
                            newPt = new Point(pt.x, pt.y);
                            boundary.add(newPt);
                            BubbleAlgorithm.debugPrintln("add " + String.valueOf(boundary.lastElement()));
                            missedNeighbor = true;
                            break;
                        }
                        if (!missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x - 1, pt.y);
                        nextDirection = 4;
                        break block15;
                    }
                    case 7: {
                        if (!this.hasNeighbor(pt, 7) || !missedNeighbor || nextPt != null) break;
                        nextPt = new Point(pt.x - 1, pt.y - 1);
                        nextDirection = 4;
                        break block15;
                    }
                }
                direction = (direction + 1) % 8;
            }
            direction = nextDirection;
            pt = nextPt;
            if (pt == null) return boundary;
        } while (!startPt.equals(pt));
        return boundary;
    }

    boolean hasNeighbor(Point pt, int direction) {
        boolean foundNeighbor = false;
        switch (direction) {
            case 0: {
                try {
                    if (this.idGrid[pt.y - 1][pt.x] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                try {
                    if (this.idGrid[pt.y - 1][pt.x + 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    if (this.idGrid[pt.y][pt.x + 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                try {
                    if (this.idGrid[pt.y + 1][pt.x + 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                try {
                    if (this.idGrid[pt.y + 1][pt.x] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 5: {
                try {
                    if (this.idGrid[pt.y + 1][pt.x - 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 6: {
                try {
                    if (this.idGrid[pt.y][pt.x - 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                }
                catch (Exception exception) {}
                break;
            }
            case 7: {
                try {
                    if (this.idGrid[pt.y - 1][pt.x - 1] != Integer.MAX_VALUE) break;
                    foundNeighbor = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return foundNeighbor;
    }

    public void printStatistics() {
        if (this.idList == null) {
            System.out.println("Layout hasn't been computed yet");
        } else {
            System.out.print("Sizes: ");
            for (int i = 0; i < this.origSizes.length; ++i) {
                System.out.print(this.origSizes[i] + " ");
            }
            System.out.println();
            System.out.println("Requested Box = " + String.valueOf(this.origBox));
            System.out.println("Final Box = " + String.valueOf(this.box));
        }
    }

    Point2D getCenterOfMass(Point[] pts) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < pts.length; ++i) {
            x += (double)pts[i].x;
            y += (double)pts[i].y;
        }
        return new Point2D.Double(x /= (double)pts.length, y /= (double)pts.length);
    }

    protected int computeArea(Rectangle rect) {
        return rect.width * rect.height;
    }

    protected int computeSize(int[] sizes) {
        int size = 0;
        if (sizes != null) {
            for (int i = 0; i < sizes.length; ++i) {
                size += sizes[i];
            }
        }
        return size;
    }

    protected double computeAspectRatio(Rectangle rect) {
        return (double)rect.width / (double)rect.height;
    }

    protected static void debugPrint(String str) {
    }

    protected static void debugPrintln(String str) {
    }
}

