/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.treemap.Algorithm;
import com.treemap.PivotByAlgorithm;
import com.treemap.app.swing.v4.settings.algorithm.CartogramAlgorithm;
import com.treemap.app.swing.v4.settings.algorithm.tagcloud.HierarchicalTagCloudAlgorithm;
import com.treemap.swing.SwingAlgorithmFactory;
import java.security.AccessControlException;

public class MAlgorithmFactory
extends SwingAlgorithmFactory {
    public static final Algorithm CARTOGRAM = new CartogramAlgorithm();
    public static final Algorithm HIEARCHICAL_TAG_CLOUD = new HierarchicalTagCloudAlgorithm(HierarchicalTagCloudAlgorithm.OrientationMode.AllHorizontal);
    private static final MAlgorithmFactory ourInstance = new MAlgorithmFactory(BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, SPLIT, BAR, ICICLE, CIRCULAR, PIE, VORONOI, TAG_CLOUD, MATRIX);
    private static final MAlgorithmFactory sunburstInstance = new MAlgorithmFactory(new Algorithm[]{BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, new PivotByAlgorithm((PivotByAlgorithm.Type)new PivotByAlgorithm.Biggest()), new PivotByAlgorithm((PivotByAlgorithm.Type)new PivotByAlgorithm.Middle()), SPLIT, BAR, ICICLE, CIRCULAR, PIE, SUNBURST, VORONOI, TAG_CLOUD, MATRIX});
    private static final MAlgorithmFactory geoInstance = new MAlgorithmFactory(BINARY_TREE, SLICE, SQUARIFIED, STRIP, PIVOT_BY_SPLIT_SIZE, SPLIT, BAR, CIRCULAR, PIE, VORONOI, TAG_CLOUD, MATRIX, CARTOGRAM);
    private static final MAlgorithmFactory expertInstance = new MAlgorithmFactory(new Algorithm[]{BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, new PivotByAlgorithm((PivotByAlgorithm.Type)new PivotByAlgorithm.Biggest()), new PivotByAlgorithm((PivotByAlgorithm.Type)new PivotByAlgorithm.Middle()), SPLIT, BAR, ICICLE, CIRCULAR, CIRCLEPACKING, PIE, SUNBURST, VORONOI, TAG_CLOUD, MATRIX, HIEARCHICAL_TAG_CLOUD, CARTOGRAM});

    private MAlgorithmFactory(Algorithm ... entries) {
        super(entries);
    }

    public static MAlgorithmFactory getInstance() {
        try {
            if (System.getProperty("sunburst") != null && Boolean.parseBoolean(System.getProperty("sunburst")) || System.getProperty("icicle") != null && Boolean.parseBoolean(System.getProperty("icicle"))) {
                return sunburstInstance;
            }
            return ourInstance;
        }
        catch (AccessControlException e) {
            return ourInstance;
        }
    }

    public static MAlgorithmFactory getInstance(boolean expertMode, boolean geoMode) {
        if (expertMode) {
            return expertInstance;
        }
        if (geoMode) {
            return geoInstance;
        }
        return MAlgorithmFactory.getInstance();
    }
}

