/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Texturing;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFImage;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing.TextureProperties;

public class PixelTexture
extends X3DConcreteNode
implements org.web3d.x3d.sai.Texturing.PixelTexture {
    private ArrayList<String> commentsList;
    private ArrayList<Integer> image = new ArrayList();
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private boolean repeatS;
    private boolean repeatT;
    private TextureProperties textureProperties;
    private ProtoInstance texturePropertiesProtoInstance;
    public static final String NAME = "PixelTexture";
    public static final String COMPONENT = "Texturing";
    public static final int LEVEL = 1;
    public static final ArrayList<Integer> IMAGE_DEFAULT_VALUE = new ArrayList<Integer>(Arrays.asList(0, 0, 0));
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final boolean REPEATS_DEFAULT_VALUE = true;
    public static final boolean REPEATT_DEFAULT_VALUE = true;
    public static final TextureProperties TEXTUREPROPERTIES_DEFAULT_VALUE = null;
    public static final String containerField_DEFAULT_VALUE = "texture";
    public static final String fromField_IMAGE = "image";
    public static final String toField_IMAGE = "image";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    static final int WIDTH_INDEX = 0;
    static final int HEIGHT_INDEX = 1;
    static final int NUMBER_COMPONENTS_INDEX = 2;
    static final int NUMBER_PARAMETERS = 3;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "image": {
                result = "SFImage";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "repeatS": {
                result = "SFBool";
                break;
            }
            case "repeatT": {
                result = "SFBool";
                break;
            }
            case "textureProperties": {
                result = "SFNode";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "image": {
                result = "inputOutput";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "repeatS": {
                result = "initializeOnly";
                break;
            }
            case "repeatT": {
                result = "initializeOnly";
                break;
            }
            case "textureProperties": {
                result = "initializeOnly";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public PixelTexture() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE, "back", "bottom", "front", "left", "right", "top", "backTexture", "bottomTexture", "frontTexture", "leftTexture", "rightTexture", "topTexture"};
        this.image = IMAGE_DEFAULT_VALUE;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.repeatS = true;
        this.repeatT = true;
        this.textureProperties = null;
        this.texturePropertiesProtoInstance = null;
        this.commentsList = new ArrayList();
    }

    @Override
    public int[] getImage() {
        int[] valuesArray = new int[this.image.size()];
        int i = 0;
        for (Integer arrayElement : this.image) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<Integer> getImageList() {
        return this.image;
    }

    public String getImageString() {
        StringBuilder result = new StringBuilder();
        for (Integer arrayElement : this.image) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public PixelTexture setImage(int[] newValue) {
        if (newValue == null) {
            return this.setImage(IMAGE_DEFAULT_VALUE);
        }
        this.clearImage();
        for (int i = 0; i < newValue.length; ++i) {
            this.image.add(newValue[i]);
        }
        return this;
    }

    public PixelTexture setImage(SFImage newValue) {
        if (newValue == null) {
            return this.setImage(IMAGE_DEFAULT_VALUE);
        }
        this.setImage(newValue.getPrimitiveValue());
        return this;
    }

    public PixelTexture setImage(ArrayList<Integer> newValue) {
        if (newValue == null) {
            return this.setImage(IMAGE_DEFAULT_VALUE);
        }
        if (newValue.isEmpty()) {
            this.clearImage();
        } else {
            int[] newArray = new int[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setImage(newArray);
        }
        return this;
    }

    public PixelTexture clearImage() {
        this.image.clear();
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public PixelTexture setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public PixelTexture clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public PixelTexture setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public PixelTexture clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public PixelTexture setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public boolean getRepeatS() {
        return this.repeatS;
    }

    @Override
    public PixelTexture setRepeatS(boolean newValue) {
        this.repeatS = newValue;
        return this;
    }

    public PixelTexture setRepeatS(SFBool newValue) {
        this.setRepeatS(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getRepeatT() {
        return this.repeatT;
    }

    @Override
    public PixelTexture setRepeatT(boolean newValue) {
        this.repeatT = newValue;
        return this;
    }

    public PixelTexture setRepeatT(SFBool newValue) {
        this.setRepeatT(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public TextureProperties getTextureProperties() {
        return this.textureProperties;
    }

    @Override
    public PixelTexture setTextureProperties(TextureProperties newValue) {
        this.textureProperties = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.textureProperties)).setParent(this);
        }
        if (this.texturePropertiesProtoInstance != null) {
            this.texturePropertiesProtoInstance.setParent(null);
            this.texturePropertiesProtoInstance = null;
        }
        return this;
    }

    public PixelTexture clearTextureProperties() {
        ((X3DConcreteElement)((Object)this.textureProperties)).clearParent();
        this.textureProperties = null;
        return this;
    }

    public PixelTexture setTextureProperties(ProtoInstance newValue) {
        if (this.texturePropertiesProtoInstance != null) {
            this.texturePropertiesProtoInstance.setParent(null);
        }
        this.texturePropertiesProtoInstance = newValue;
        if (newValue != null) {
            this.texturePropertiesProtoInstance.setParent(this);
            this.texturePropertiesProtoInstance.setContainerField("textureProperties");
        }
        if (this.textureProperties != null) {
            ((X3DConcreteElement)((Object)this.textureProperties)).setParent(null);
            this.textureProperties = null;
        }
        return this;
    }

    private ProtoInstance getTexturePropertiesProtoInstance() {
        return this.texturePropertiesProtoInstance;
    }

    public boolean hasTextureProperties() {
        return this.textureProperties != null || this.texturePropertiesProtoInstance != null;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final PixelTexture setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PixelTexture DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public PixelTexture setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final PixelTexture setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("PixelTexture USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public PixelTexture setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final PixelTexture setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public PixelTexture setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public PixelTexture setUSE(PixelTexture DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on PixelTexture that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public PixelTexture(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public PixelTexture addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public PixelTexture addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public PixelTexture addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.textureProperties != null || this.texturePropertiesProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<PixelTexture");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getImage().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" image='").append(SFImage.toString(this.getImage())).append("'");
            }
            if (!(this.getRepeatS() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" repeatS='").append(SFBool.toString(this.getRepeatS())).append("'");
            }
            if (!(this.getRepeatT() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" repeatT='").append(SFBool.toString(this.getRepeatT())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.textureProperties != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.textureProperties)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.texturePropertiesProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.texturePropertiesProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</PixelTexture>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.textureProperties != null || this.texturePropertiesProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("image")) continue;
                        stringClassicVRML.append(indentCharacter).append("image").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getImage().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("image ").append(SFImage.toString(this.getImage())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("repeatS")) continue;
                        stringClassicVRML.append(indentCharacter).append("repeatS").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getRepeatS() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("repeatS ").append(SFBool.toString(this.getRepeatS())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("repeatT")) continue;
                        stringClassicVRML.append(indentCharacter).append("repeatT").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getRepeatT() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("repeatT ").append(SFBool.toString(this.getRepeatT())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.textureProperties != null) {
                stringClassicVRML.append(indentCharacter).append("textureProperties").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.textureProperties)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.texturePropertiesProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("textureProperties").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.texturePropertiesProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.textureProperties != null && (referenceElement = ((X3DConcreteElement)((Object)this.textureProperties)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.texturePropertiesProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.texturePropertiesProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.textureProperties != null && (referenceNode = ((X3DConcreteElement)((Object)this.textureProperties)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.texturePropertiesProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.texturePropertiesProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setImage(this.getImage());
        this.setRepeatS(this.getRepeatS());
        this.setRepeatT(this.getRepeatT());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.textureProperties != null) {
            this.setTextureProperties(this.getTextureProperties());
            ((X3DConcreteElement)((Object)this.textureProperties)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.textureProperties)).getValidationResult());
        }
        if (this.texturePropertiesProtoInstance != null) {
            this.setTextureProperties(this.getTexturePropertiesProtoInstance());
            ((X3DConcreteElement)this.texturePropertiesProtoInstance).validate();
            this.validationResult.append(this.texturePropertiesProtoInstance.getValidationResult());
        }
        if (this.textureProperties != null && this.texturePropertiesProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both textureProperties and texturePropertiesProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasTextureProperties()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained SFNode textureProperties";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "PixelTexture USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.image.size() != this.getWidth() * this.getHeight() + 3) {
            String errorNotice = "Illegal length of PixelTexture image integer array (" + this.image.size() + ") while ((width=" + this.getWidth() + " * height=" + this.getHeight() + " expects number of pixels=" + this.getWidth() * this.getHeight();
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'PixelTexture' node, add head statement <component name='Texturing' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Texturing\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }

    public int getExpectedLength() {
        return this.getWidth() * this.getHeight();
    }

    public int getWidth() {
        int width = 0;
        if (this.image.size() >= 3 && ((width = this.image.get(0).intValue()) < 0 || width > this.image.size())) {
            String errorNotice = "erroneous image width=" + width + " for PixelTexture";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return width;
    }

    public int getHeight() {
        int height = 0;
        if (this.image.size() >= 3 && ((height = this.image.get(1).intValue()) < 0 || height > this.image.size())) {
            String errorNotice = "erroneous image height=" + height + " for PixelTexture";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return height;
    }

    public int getNumberComponents() {
        int numberComponents = 0;
        if (this.image.size() >= 3 && ((numberComponents = this.image.get(2).intValue()) < 0 || numberComponents > 4)) {
            String errorNotice = "erroneous image numberComponents=" + numberComponents + " for PixelTexture";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return numberComponents;
    }

    public int[] getPixels() {
        int[] valuesArray = new int[]{};
        if (this.image.size() >= 3) {
            valuesArray = new int[this.image.size() - 3];
            for (int i = 3; i < this.image.size(); ++i) {
                valuesArray[i - 3] = this.image.get(i);
            }
        }
        return valuesArray;
    }

    public String getPixelsString() {
        StringBuilder result = new StringBuilder();
        String hexFormat = SFImage.getPixelHexFormat(this.getNumberComponents());
        int[] destinationPixels = this.getPixels();
        for (int i = 0; i < destinationPixels.length; ++i) {
            result.append(String.format(hexFormat, destinationPixels[i]));
            result.append(" ");
        }
        return result.toString().trim();
    }
}

