/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import org.web3d.x3d.jsail.fields.SFNode;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFNode
extends X3DConcreteField
implements org.web3d.x3d.sai.MFNode {
    public static final String NAME = "MFNode";
    public static final X3DNode[] DEFAULT_VALUE = new X3DNode[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    private X3DNode[] MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFNode() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public MFNode(X3DNode newValue) {
        this.setValue(new SFNode(newValue));
    }

    public MFNode(SFNode newValue) {
        if (newValue == null) {
            this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFNode = new X3DNode[1];
        this.MFNode[0] = newValue.getValue();
    }

    public MFNode(MFNode newValue) {
        if (newValue == null) {
            this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFNode = newValue.getPrimitiveValue();
    }

    public MFNode(X3DNode[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFNode = newValue;
    }

    public static String toString(X3DNode[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(X3DNode[] valueDestination) {
        valueDestination = this.MFNode;
    }

    public X3DNode[] getPrimitiveValue() {
        return this.MFNode;
    }

    public String toString() {
        return "TODO";
    }

    @Override
    public X3DNode get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFNode.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFNode.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFNode array length=" + this.MFNode.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFNode[index];
    }

    @Override
    public void setValue(int size, X3DNode[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFNode = Arrays.copyOf(newValue, size);
    }

    public void setValue(X3DNode[] newValue) {
        if (newValue == null) {
            newValue = new X3DNode[]{};
        }
        this.MFNode = new X3DNode[newValue.length];
        this.MFNode = newValue;
    }

    public MFNode setValue(SFNode newValue) {
        if (newValue == null) {
            this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFNode = new X3DNode[1];
        this.MFNode[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, X3DNode newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFNode.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFNode.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFNode array length=" + this.MFNode.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFNode[index] = newValue;
    }

    @Override
    public void append(X3DNode newValue) {
        this.MFNode = Arrays.copyOf(this.MFNode, this.MFNode.length + 1);
        this.MFNode[this.MFNode.length - 1] = newValue;
    }

    public void append(X3DNode[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFNode.length;
        this.MFNode = Arrays.copyOf(this.MFNode, this.MFNode.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFNode[originalLength + i] = newValue[i];
        }
    }

    public MFNode append(SFNode newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFNode append(MFNode newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, X3DNode newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFNode.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFNode array length=" + this.MFNode.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFNode.length - index;
        this.MFNode = Arrays.copyOf(this.MFNode, this.MFNode.length + 1);
        System.arraycopy(this.MFNode, index, this.MFNode, index + 1, sliceLength);
        this.MFNode[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFNode.length;
    }

    @Override
    public void clear() {
        this.MFNode = new X3DNode[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFNode.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFNode.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFNode array length=" + this.MFNode.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFNode.length - (index + 1) * 1;
        System.arraycopy(this.MFNode, (index + 1) * 1, this.MFNode, index * 1, offsetLength);
        this.MFNode = Arrays.copyOfRange(this.MFNode, 0, this.MFNode.length - 1);
    }

    public MFNode setValue(MFNode newValue) {
        if (newValue == null) {
            this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFNode = newValue.getPrimitiveValue();
        return this;
    }

    public MFNode clearChildren() {
        this.MFNode = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFNode, DEFAULT_VALUE);
    }
}

