/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import org.web3d.x3d.jsail.fields.X3DConcreteFieldTypes;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.X3DFieldDefinition;

public abstract class X3DConcreteFieldDefinition
implements X3DFieldDefinition {
    private String name = "";
    private int accessType = 3;
    private int fieldType = 27;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name.contains(" ")) {
            this.name = newValue;
        }
    }

    @Override
    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int newValue) {
        if (newValue < 1 || newValue > 4) {
            String errorNotice = "Illegal value " + newValue + " for field type";
            throw new InvalidFieldValueException(errorNotice);
        }
        this.accessType = newValue;
    }

    @Override
    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int newValue) {
        if (newValue < 1 || newValue > 42) {
            String errorNotice = "Illegal value " + newValue + " for field type";
            throw new InvalidFieldValueException(errorNotice);
        }
        this.fieldType = newValue;
    }

    @Override
    public String getFieldTypeString() {
        return X3DConcreteFieldTypes.toFieldString(this.fieldType);
    }
}

