/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d.iconpainter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import de.javasoft.synthetica.simple2d.SyntheticaSimple2DLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class RadioButtonIconPainter
extends SyntheticaBasicIconPainter {
    public RadioButtonIconPainter() {
        super(null, 14, 14);
    }

    public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean focused = (sc.getComponentState() & 0x100) > 0;
        boolean hover = (sc.getComponentState() & 2) > 0;
        JComponent c = sc.getComponent();
        Color bg = this.getSyntheticaBackgroundColor(c);
        Synthetica2DUtils.BlendMode bm = this.getSyntheticaBackgroundBlendMode(c);
        Shape shape = this.createShape(0.0f, 0.0f, w, h, w);
        if (disabled) {
            g2.setPaint(new Color(0x19FFFFFF, true));
        } else if (pressed && selected) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{this.blend(new Color(0x808080), bg, bm), this.blend(new Color(0xAAAAAA), bg, bm)}));
        } else if (pressed) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{this.blend(new Color(0xAAAAAA), bg, bm), this.blend(new Color(0xCCCCCC), bg, bm)}));
        } else if (selected) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 1.0f}, new Color[]{this.blend(new Color(0xAAAAAA), bg, bm), this.blend(new Color(0xC0C0C0), bg, bm)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, 0.0f, 0.0f, h, new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{this.blend(new Color(0xFCFCFC), bg, bm), this.blend(new Color(0xF0F0F0), bg, bm), this.blend(new Color(0xE8E8E8), bg, bm), this.blend(new Color(0xDCDCDC), bg, bm)}));
        }
        g2.fill(RadioButtonIconPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        if (disabled) {
            g2.setPaint(new Color(0x2E000000, true));
        } else if (pressed && selected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x7F000000, true), 0.0f, h, new Color(0x4C000000, true)));
        } else if (pressed) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x4C000000, true), 0.0f, h, new Color(0x33000000, true)));
        } else if (selected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x4C000000, true), 0.0f, h, new Color(0x7F000000, true)));
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0x33000000, true), 0.0f, h, new Color(0x4C000000, true)));
        }
        g2.draw(shape);
        boolean paintFocus = (Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.paintFocus", (JComponent)sc.getComponent(), (Object)true);
        if (focused && ((AbstractButton)sc.getComponent()).isFocusPainted() && paintFocus) {
            float strokeWidth = 2.0f;
            shape = this.createShape((strokeWidth - 1.0f) / 2.0f, (strokeWidth - 1.0f) / 2.0f, w - strokeWidth + 1.0f, h - strokeWidth + 1.0f, w - strokeWidth + 1.0f);
            g2.setStroke(new BasicStroke(strokeWidth));
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getFocusColor());
            g2.draw(shape);
        }
        if (selected) {
            shape = this.createSelectedShape(3.5f, 3.5f, w - 7.0f, h - 7.0f, w - 7.0f);
            if (disabled) {
                g2.setPaint(new Color(0xA0A0A0));
            } else if (pressed) {
                g2.setPaint(new Color(0xF0F0F0));
            } else {
                g2.setPaint(Color.WHITE);
            }
            g2.fill(shape);
        }
        if (hover) {
            shape = this.createShape(0.0f, 0.0f, w, h, w);
            g2.setPaint(SyntheticaSimple2DLookAndFeel.getHoverColor());
            g2.fill(RadioButtonIconPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        }
    }

    private Shape createShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }

    private Shape createSelectedShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }
}

