/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openexi.proc.common.Channel;
import org.openexi.proc.common.IGrammar;
import org.openexi.proc.common.IGrammarCache;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchema;
import org.openexi.schema.EXISchemaConst;

public final class StringTable {
    public final GlobalValuePartition globalValuePartition;
    private final LinkedList<Channel> channels;
    private int n_channels;
    private static final String[] EMPTY = new String[0];
    private static final String[] DEFAULT_PREFIXES = new String[]{""};
    private static final String[] XML_PREFIXES = new String[]{"xml"};
    private static final String[] XSI_PREFIXES = new String[]{"xsi"};
    private final IGrammarCache m_grammarCache;
    private final boolean m_hasSchema;
    private int m_valuePartitionCapacity;
    private final boolean m_useMap;
    private URIEntry[] m_uriList;
    public int n_uris = 0;
    public int uriWidth = 0;
    private final int m_start_n_uris;
    private final int m_start_uriForwardedWidth;
    private final Map<String, URIEntry> m_uriMap;
    private final LocalNamePartition[] m_initialLocalNamePartitions;
    private final PrefixPartition[] m_initialPrefixPartitions;

    public StringTable(IGrammarCache iGrammarCache, Usage usage) {
        LocalNamePartition localNamePartition;
        LocalNamePartition[] localNamePartitionArray;
        Object object;
        this.m_grammarCache = iGrammarCache;
        EXISchema eXISchema = iGrammarCache != null ? iGrammarCache.getEXISchema() : null;
        this.m_useMap = usage == Usage.encoding;
        this.m_hasSchema = eXISchema != null;
        this.globalValuePartition = new GlobalValuePartition();
        this.m_valuePartitionCapacity = -1;
        this.channels = new LinkedList();
        this.n_channels = 0;
        if (this.m_hasSchema) {
            object = eXISchema.getLocalNames();
            localNamePartitionArray = new LocalNamePartition[((int[][])object).length];
            for (int i = 0; i < ((int[][])object).length; ++i) {
                localNamePartition = new LocalNamePartition(eXISchema.uris[i], eXISchema.localNames[i], eXISchema);
                localNamePartition.uriId = i;
                localNamePartitionArray[i] = localNamePartition;
            }
        } else {
            localNamePartitionArray = new LocalNamePartition[3];
            object = new LocalNamePartition("", new String[0], null);
            object.uriId = 0;
            localNamePartitionArray[0] = object;
            object = new LocalNamePartition("http://www.w3.org/XML/1998/namespace", EXISchemaConst.XML_LOCALNAMES, null);
            object.uriId = 1;
            localNamePartitionArray[1] = object;
            object = new LocalNamePartition("http://www.w3.org/2001/XMLSchema-instance", EXISchemaConst.XSI_LOCALNAMES, null);
            object.uriId = 2;
            localNamePartitionArray[2] = object;
        }
        PrefixPartition[] prefixPartitionArray = new PrefixPartition[]{new PrefixPartition(DEFAULT_PREFIXES), new PrefixPartition(XML_PREFIXES), new PrefixPartition(XSI_PREFIXES)};
        HashMap hashMap = this.m_uriMap = this.m_useMap ? new HashMap() : null;
        assert (prefixPartitionArray.length == 3 && prefixPartitionArray.length <= localNamePartitionArray.length);
        this.m_initialLocalNamePartitions = localNamePartitionArray;
        this.m_initialPrefixPartitions = prefixPartitionArray;
        this.m_uriList = new URIEntry[32];
        for (int i = 0; i < this.m_initialLocalNamePartitions.length; ++i) {
            LocalNamePartition localNamePartition2 = this.m_initialLocalNamePartitions[i];
            localNamePartition = i < 3 ? prefixPartitionArray[i] : null;
            this.addURI(localNamePartition2.uri, localNamePartition2, (PrefixPartition)((Object)localNamePartition));
        }
        this.m_start_n_uris = this.n_uris;
        this.m_start_uriForwardedWidth = this.uriWidth;
    }

    public void reset() {
        Object object;
        int n;
        int n2 = this.m_initialLocalNamePartitions.length;
        int n3 = this.m_initialPrefixPartitions.length;
        if (this.m_useMap) {
            this.m_uriMap.clear();
            for (n = 0; n < n2; ++n) {
                object = this.m_initialLocalNamePartitions[n];
                ((LocalNamePartition)object).reset();
                this.m_uriMap.put(((LocalNamePartition)object).uri, this.m_uriList[n]);
            }
            for (n = 0; n < n3; ++n) {
                this.m_initialPrefixPartitions[n].reset();
            }
            for (n = n3; n < n2; ++n) {
                object = this.m_uriList[n].prefixPartition;
                if (object == null) continue;
                ((PrefixPartition)object).reset();
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.m_initialLocalNamePartitions[n].reset();
            }
            for (n = 0; n < n3; ++n) {
                this.m_initialPrefixPartitions[n].reset();
            }
            for (n = n3; n < n2; ++n) {
                object = this.m_uriList[n].prefixPartition;
                if (object == null) continue;
                ((PrefixPartition)object).reset();
            }
        }
        this.n_uris = this.m_start_n_uris;
        this.uriWidth = this.m_start_uriForwardedWidth;
        this.globalValuePartition.reset();
        if (this.n_channels != 0) {
            Iterator iterator = this.channels.iterator();
            while (iterator.hasNext()) {
                ((Channel)iterator.next()).blockNum = -1;
            }
        }
    }

    public int getValuePartitionCapacity() {
        return this.m_valuePartitionCapacity;
    }

    public void setValuePartitionCapacity(int n) {
        this.m_valuePartitionCapacity = n;
    }

    public String getURI(int n) {
        return this.m_uriList[n].value;
    }

    public int getCompactIdOfURI(String string) {
        URIEntry uRIEntry = this.m_uriMap.get(string);
        if (uRIEntry != null) {
            return uRIEntry.number;
        }
        return -1;
    }

    public int internURI(String string) {
        int n = this.getCompactIdOfURI(string);
        if (n != -1) {
            return n;
        }
        return this.addURI(string, null, null);
    }

    public int addURI(String string, LocalNamePartition localNamePartition, PrefixPartition prefixPartition) {
        URIEntry uRIEntry;
        int n = this.n_uris;
        int n2 = this.m_uriList.length;
        if (n2 == this.n_uris) {
            uRIEntry = null;
            int n3 = 2 * n2;
            URIEntry[] uRIEntryArray = new URIEntry[n3];
            System.arraycopy(this.m_uriList, 0, uRIEntryArray, 0, n2);
            this.m_uriList = uRIEntryArray;
        } else {
            uRIEntry = this.m_uriList[n];
            if (uRIEntry != null) {
                assert (localNamePartition == null);
                localNamePartition = uRIEntry.localNamePartition;
                localNamePartition.reset();
                localNamePartition.uri = string;
            }
        }
        if (localNamePartition == null) {
            localNamePartition = new LocalNamePartition(string);
        }
        localNamePartition.uriId = n;
        if (uRIEntry == null) {
            uRIEntry = new URIEntry(string, n, localNamePartition, prefixPartition);
        } else {
            uRIEntry.value = string;
            uRIEntry.number = n;
            uRIEntry.localNamePartition = localNamePartition;
            uRIEntry.prefixPartition = prefixPartition;
        }
        if (this.m_useMap) {
            this.m_uriMap.put(string, uRIEntry);
        }
        this.m_uriList[this.n_uris] = uRIEntry;
        if ((this.n_uris++ & this.n_uris) == 0) {
            ++this.uriWidth;
        }
        return n;
    }

    public LocalNamePartition getLocalNamePartition(int n) {
        return this.m_uriList[n].localNamePartition;
    }

    public PrefixPartition getPrefixPartition(int n) {
        URIEntry uRIEntry = this.m_uriList[n];
        PrefixPartition prefixPartition = uRIEntry.prefixPartition;
        if (prefixPartition != null) {
            return prefixPartition;
        }
        uRIEntry.prefixPartition = new PrefixPartition();
        return uRIEntry.prefixPartition;
    }

    public static final class GlobalEntry {
        public final Characters value;
        public final int number;
        public final LocalValuePartition localPartition;
        public final NumberedCharacters localEntry;

        GlobalEntry(Characters characters, int n, LocalValuePartition localValuePartition, NumberedCharacters numberedCharacters) {
            this.value = characters;
            this.number = n;
            this.localPartition = localValuePartition;
            this.localEntry = numberedCharacters;
        }
    }

    public final class GlobalValuePartition {
        public GlobalEntry[] valueEntries;
        private final HashMap<Characters, GlobalEntry> m_stringMap;
        public int globalID = 0;
        public int width = 0;
        private int m_milestone = 1;
        private boolean m_wrapped = false;

        GlobalValuePartition() {
            this.m_stringMap = StringTable.this.m_useMap ? new HashMap() : null;
            this.valueEntries = new GlobalEntry[1];
        }

        public void reset() {
            if (StringTable.this.m_useMap) {
                this.m_stringMap.clear();
            }
            this.init();
        }

        private void init() {
            this.globalID = 0;
            this.width = 0;
            this.m_milestone = 1;
            this.m_wrapped = false;
        }

        public GlobalEntry getEntry(Characters characters) {
            GlobalEntry globalEntry = this.m_stringMap.get(characters);
            if (globalEntry != null) {
                return globalEntry;
            }
            return null;
        }

        public LocalValuePartition getLocalPartition(int n, int n2) {
            LocalNamePartition localNamePartition = StringTable.this.getLocalNamePartition(n2);
            return localNamePartition.getLocalValuePartition(n);
        }

        public void addValue(Characters characters, int n, int n2) {
            if (characters.isVolatile) {
                characters.turnPermanent();
            }
            if (StringTable.this.m_valuePartitionCapacity != 0) {
                GlobalEntry globalEntry;
                LocalValuePartition localValuePartition = StringTable.this.getLocalNamePartition(n2).getLocalValuePartition(n);
                int n3 = localValuePartition.addString(characters);
                GlobalEntry globalEntry2 = new GlobalEntry(characters, this.globalID, localValuePartition, localValuePartition.valueEntries[n3]);
                if (this.globalID == this.valueEntries.length) {
                    int n4 = 2 * this.globalID;
                    GlobalEntry[] globalEntryArray = new GlobalEntry[n4];
                    System.arraycopy(this.valueEntries, 0, globalEntryArray, 0, this.globalID);
                    this.valueEntries = globalEntryArray;
                }
                if (this.globalID == this.m_milestone) {
                    ++this.width;
                    this.m_milestone <<= 1;
                }
                if ((globalEntry = this.valueEntries[this.globalID]) != null) {
                    if (this.m_wrapped) {
                        globalEntry.localPartition.releaseEntry(globalEntry.localEntry.number);
                    }
                    if (StringTable.this.m_useMap) {
                        this.m_stringMap.remove(globalEntry.value);
                    }
                }
                this.valueEntries[this.globalID] = globalEntry2;
                if (StringTable.this.m_useMap) {
                    this.m_stringMap.put(characters, globalEntry2);
                }
                if (++this.globalID == StringTable.this.m_valuePartitionCapacity) {
                    this.globalID = 0;
                    this.m_wrapped = true;
                }
            }
        }
    }

    public static final class LocalValuePartition {
        public NumberedCharacters[] valueEntries = new NumberedCharacters[1];
        public int n_strings = 0;
        public int width = 0;
        private int m_milestone = 1;
        private final LocalNamePartition m_localNamePartition;

        LocalValuePartition(LocalNamePartition localNamePartition) {
            this.m_localNamePartition = localNamePartition;
        }

        void reset() {
            this.n_strings = 0;
            this.width = 0;
            this.m_milestone = 1;
        }

        void releaseEntry(int n) {
            this.valueEntries[n] = null;
        }

        int addString(Characters characters) {
            int n = this.n_strings;
            NumberedCharacters numberedCharacters = new NumberedCharacters(characters, n);
            int n2 = this.valueEntries.length;
            if (this.n_strings == n2) {
                int n3 = 2 * n2;
                NumberedCharacters[] numberedCharactersArray = new NumberedCharacters[n3];
                System.arraycopy(this.valueEntries, 0, numberedCharactersArray, 0, n2);
                this.valueEntries = numberedCharactersArray;
            }
            if (this.n_strings == this.m_milestone) {
                ++this.width;
                this.m_milestone <<= 1;
            }
            this.valueEntries[this.n_strings] = numberedCharacters;
            if (this.n_strings++ == 0) {
                this.m_localNamePartition.addTouchedValuePartitions(this);
            }
            return n;
        }
    }

    public static class NumberedCharacters {
        public final Characters value;
        public final int number;

        NumberedCharacters(Characters characters, int n) {
            this.value = characters;
            this.number = n;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class URIEntry {
        String value;
        int number;
        LocalNamePartition localNamePartition;
        PrefixPartition prefixPartition;

        URIEntry(String string, int n, LocalNamePartition localNamePartition, PrefixPartition prefixPartition) {
            this.value = string;
            this.number = n;
            this.localNamePartition = localNamePartition;
            this.prefixPartition = prefixPartition;
        }

        public final int hashCode() {
            return this.value.hashCode();
        }
    }

    public final class PrefixPartition {
        public PrefixEntry[] prefixEntries;
        public int n_strings = 0;
        public int width = 0;
        public int forwardedWidth = 0;
        private int m_milestone = 1;
        private final int m_start_n_strings;
        private final int m_start_width;
        private final int m_start_forwardedWidth;
        private final int m_start_milestone;
        private final HashMap<String, PrefixEntry> m_prefixMap;
        private final String[] m_prefixes;

        private PrefixPartition() {
            this(EMPTY);
        }

        private PrefixPartition(String[] stringArray) {
            this.m_prefixMap = StringTable.this.m_useMap ? new HashMap() : null;
            this.m_prefixes = stringArray;
            this.prefixEntries = new PrefixEntry[1];
            int n = this.m_prefixes.length;
            for (int i = 0; i < n; ++i) {
                this.addPrefix(this.m_prefixes[i]);
            }
            this.m_start_n_strings = this.n_strings;
            this.m_start_width = this.width;
            this.m_start_forwardedWidth = this.forwardedWidth;
            this.m_start_milestone = this.m_milestone;
        }

        public void reset() {
            if (StringTable.this.m_useMap) {
                this.m_prefixMap.clear();
                int n = this.m_prefixes.length;
                for (int i = 0; i < n; ++i) {
                    this.m_prefixMap.put(this.m_prefixes[i], this.prefixEntries[i]);
                }
            }
            this.n_strings = this.m_start_n_strings;
            this.width = this.m_start_width;
            this.forwardedWidth = this.m_start_forwardedWidth;
            this.m_milestone = this.m_start_milestone;
        }

        public int getCompactId(String string) {
            PrefixEntry prefixEntry = this.m_prefixMap.get(string);
            if (prefixEntry != null) {
                return prefixEntry.number;
            }
            return -1;
        }

        public int internPrefix(String string) {
            int n = this.getCompactId(string);
            if (n != -1) {
                return n;
            }
            return this.addPrefix(string);
        }

        public int addPrefix(String string) {
            int n = this.n_strings;
            PrefixEntry prefixEntry = new PrefixEntry(string, n);
            int n2 = this.prefixEntries.length;
            if (this.n_strings == n2) {
                int n3 = 2 * n2;
                PrefixEntry[] prefixEntryArray = new PrefixEntry[n3];
                System.arraycopy(this.prefixEntries, 0, prefixEntryArray, 0, n2);
                this.prefixEntries = prefixEntryArray;
                n2 = n3;
            }
            if (StringTable.this.m_useMap) {
                this.m_prefixMap.put(string, prefixEntry);
            }
            this.prefixEntries[this.n_strings] = prefixEntry;
            if (this.n_strings++ == this.m_milestone) {
                ++this.width;
                this.m_milestone <<= 1;
            }
            if (this.n_strings == this.m_milestone) {
                ++this.forwardedWidth;
            }
            return n;
        }
    }

    public static final class PrefixEntry {
        public final String value;
        final int number;

        PrefixEntry(String string, int n) {
            this.value = string;
            this.number = n;
        }

        public final int hashCode() {
            return this.value.hashCode();
        }
    }

    public final class LocalNamePartition {
        public LocalNameEntry[] localNameEntries;
        public int n_strings = 0;
        public int width = 0;
        private int m_milestone = 1;
        private final int m_start_n_strings;
        private final int m_start_width;
        private final int m_start_milestone;
        private final HashMap<String, LocalNameEntry> m_nameMap;
        String uri;
        int uriId;
        private final String[] m_initialNames;
        private int m_n_localValuePartitionsTouched;
        private LocalValuePartition[] m_localValuePartitionsTouched;
        private int m_n_grammarsTouched;
        private IGrammar[] m_grammarsTouched;

        LocalNamePartition(String string) {
            this(string, EMPTY, null);
        }

        LocalNamePartition(String string, String[] stringArray, EXISchema eXISchema) {
            this.uri = string;
            this.uriId = -1;
            if (StringTable.this.m_useMap) {
                this.m_nameMap = new HashMap();
                this.m_initialNames = stringArray;
            } else {
                this.m_nameMap = null;
                this.m_initialNames = null;
            }
            this.localNameEntries = new LocalNameEntry[256];
            for (String string2 : stringArray) {
                int n;
                IGrammar iGrammar = eXISchema != null ? ((n = eXISchema.getGlobalElemOfSchema(string, string2)) != -1 ? StringTable.this.m_grammarCache.getElementGrammarUse(n) : null) : null;
                this.addName(string2, iGrammar);
            }
            this.m_start_n_strings = this.n_strings;
            this.m_start_width = this.width;
            this.m_start_milestone = this.m_milestone;
            this.m_localValuePartitionsTouched = new LocalValuePartition[32];
            this.m_n_localValuePartitionsTouched = 0;
            this.m_grammarsTouched = new IGrammar[32];
            this.m_n_grammarsTouched = 0;
        }

        public void reset() {
            int n;
            if (StringTable.this.m_useMap) {
                this.m_nameMap.clear();
                for (n = 0; n < this.m_initialNames.length; ++n) {
                    this.m_nameMap.put(this.m_initialNames[n], this.localNameEntries[n]);
                }
            }
            for (n = 0; n < this.m_n_localValuePartitionsTouched; ++n) {
                this.m_localValuePartitionsTouched[n].reset();
            }
            this.m_n_localValuePartitionsTouched = 0;
            for (n = 0; n < this.m_n_grammarsTouched; ++n) {
                this.m_grammarsTouched[n].reset();
            }
            this.m_n_grammarsTouched = 0;
            this.n_strings = this.m_start_n_strings;
            this.width = this.m_start_width;
            this.m_milestone = this.m_start_milestone;
        }

        public void setGrammar(int n, IGrammar iGrammar) {
            this.localNameEntries[n].grammar = iGrammar;
        }

        public void setChannel(int n, Channel channel) {
            assert (this.localNameEntries[n].channel == null);
            this.localNameEntries[n].channel = channel;
            StringTable.this.channels.add(channel);
            ++StringTable.this.n_channels;
        }

        public int getCompactId(String string) {
            LocalNameEntry localNameEntry = this.m_nameMap.get(string);
            if (localNameEntry != null) {
                return localNameEntry.number;
            }
            return -1;
        }

        public int internName(String string) {
            int n = this.getCompactId(string);
            if (n != -1) {
                return n;
            }
            return this.addName(string, null);
        }

        public int addName(String string, IGrammar iGrammar) {
            LocalNameEntry localNameEntry;
            int n = this.n_strings;
            int n2 = this.localNameEntries.length;
            if (n2 == this.n_strings) {
                localNameEntry = null;
                int n3 = 2 * n2;
                LocalNameEntry[] localNameEntryArray = new LocalNameEntry[n3];
                System.arraycopy(this.localNameEntries, 0, localNameEntryArray, 0, n2);
                this.localNameEntries = localNameEntryArray;
            } else {
                localNameEntry = this.localNameEntries[n];
                if (localNameEntry != null) {
                    localNameEntry.localName = string;
                    localNameEntry.number = n;
                    LocalValuePartition localValuePartition = localNameEntry.localValuePartition;
                    if (localValuePartition != null) {
                        localValuePartition.reset();
                    }
                    assert (iGrammar == null);
                    iGrammar = localNameEntry.grammar;
                    if (iGrammar != null) {
                        iGrammar.reset();
                    }
                }
            }
            if (localNameEntry == null) {
                localNameEntry = new LocalNameEntry(string, n, iGrammar);
            }
            if (this.n_strings == this.m_milestone) {
                ++this.width;
                this.m_milestone <<= 1;
            }
            this.localNameEntries[this.n_strings++] = localNameEntry;
            if (StringTable.this.m_useMap) {
                this.m_nameMap.put(string, localNameEntry);
            }
            return n;
        }

        public LocalValuePartition getLocalValuePartition(int n) {
            LocalNameEntry localNameEntry = this.localNameEntries[n];
            LocalValuePartition localValuePartition = localNameEntry.localValuePartition;
            if (localValuePartition != null) {
                return localValuePartition;
            }
            localNameEntry.localValuePartition = new LocalValuePartition(this);
            return localNameEntry.localValuePartition;
        }

        public void addTouchedValuePartitions(LocalValuePartition localValuePartition) {
            if (this.m_n_localValuePartitionsTouched == this.m_localValuePartitionsTouched.length) {
                int n = this.m_n_localValuePartitionsTouched << 1;
                LocalValuePartition[] localValuePartitionArray = new LocalValuePartition[n];
                System.arraycopy(this.m_localValuePartitionsTouched, 0, localValuePartitionArray, 0, this.m_n_localValuePartitionsTouched);
                this.m_localValuePartitionsTouched = localValuePartitionArray;
            }
            this.m_localValuePartitionsTouched[this.m_n_localValuePartitionsTouched++] = localValuePartition;
        }

        public void addTouchedBuiltinElementGrammars(IGrammar iGrammar) {
            if (this.m_n_grammarsTouched == this.m_grammarsTouched.length) {
                int n = this.m_n_grammarsTouched << 1;
                IGrammar[] iGrammarArray = new IGrammar[n];
                System.arraycopy(this.m_grammarsTouched, 0, iGrammarArray, 0, this.m_n_grammarsTouched);
                this.m_grammarsTouched = iGrammarArray;
            }
            this.m_grammarsTouched[this.m_n_grammarsTouched++] = iGrammar;
        }
    }

    public static final class LocalNameEntry {
        public String localName;
        int number;
        LocalValuePartition localValuePartition;
        public IGrammar grammar;
        public Channel channel;

        LocalNameEntry(String string, int n, IGrammar iGrammar) {
            this.localName = string;
            this.number = n;
            this.localValuePartition = null;
            this.grammar = iGrammar;
            this.channel = null;
        }

        public final int hashCode() {
            return this.localName.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Usage {
        decoding,
        encoding;

    }
}

