/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing.layer;

import com.macrofocus.crossplatform.AbstractAveragingLayer;
import com.macrofocus.crossplatform.swing.layer.SwingLayer;
import com.macrofocus.crossplatform.swing.layer.filter.AntiAliasingBufferedImageOp;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.timer.VisualizationExecutorService;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;

public class AveragingSwingLayer
extends AbstractAveragingLayer
implements SwingLayer {
    private static final boolean MULTITHREADED = false;
    private static final int nAvailableProcessors = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private static final VisualizationExecutorService executor = null;
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private BufferedImage image;

    public AveragingSwingLayer(IDrawing iDrawing, boolean antialiasing) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            this.iDrawing.draw(this.g, null, (double)this.width, (double)this.height, new Rectangle(0, 0, this.width, this.height));
            int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < this.overlay.length; ++i) {
                int count = this.overlay[i];
                if (count > 0) {
                    float[] c = this.rgb[i];
                    float red = c[0] / (float)count;
                    float green = c[1] / (float)count;
                    float blue = c[2] / (float)count;
                    assert (red >= 0.0f && red <= 1.0f) : red + ", " + c[0] + ", " + count;
                    assert (green >= 0.0f && green <= 1.0f) : green + ", " + c[1] + ", " + count;
                    assert (blue >= 0.0f && blue <= 1.0f) : blue + ", " + c[2] + ", " + count;
                    Color color = new Color(red, green, blue);
                    pixels[i] = color.getRGB();
                    continue;
                }
                pixels[i] = 0xFFFFFF;
            }
            if (this.antialiasing) {
                this.image = this.createAntiAliasedImage(this.image);
            }
        }
    }

    void resize(int width, int height) {
        if ((this.width != width || this.height != height) && width > 0 && height > 0) {
            WritableRaster ras = Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF0000, 65280, 255, -16777216}), new Point(0, 0));
            BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216), ras, false, new Hashtable());
            int[] o = new int[width * height];
            float[][] rgb = new float[width * height][3];
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = new float[3];
            }
            this.width = width;
            this.height = height;
            this.image = bufferedImage;
            this.overlay = o;
            this.rgb = rgb;
            this.cx1 = 0;
            this.cy1 = 0;
            this.cx2 = width - 1;
            this.cy2 = height - 1;
        } else {
            this.clear();
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.iDrawing.isActive() && this.image != null) {
            g.drawImage((Image)this.image, 0, 0, null);
        }
    }

    private BufferedImage createAntiAliasedImage(BufferedImage img) {
        return img != null ? new AntiAliasingBufferedImageOp().filter(img, null) : null;
    }

    void clear() {
        if (this.image != null) {
            Arrays.fill(this.overlay, 0);
            for (float[] c : this.rgb) {
                c[0] = 0.0f;
                c[1] = 0.0f;
                c[2] = 0.0f;
            }
        }
    }
}

