/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class SyntheticaDefaultBooleanTableCellRenderer
extends JCheckBox
implements TableCellRenderer,
UIResource {
    private static final long serialVersionUID = 2605436985980373338L;
    private boolean isRowSelected;
    private Border noFocusBorder;
    private Border focusBorder;
    private Color alternateColor;

    public SyntheticaDefaultBooleanTableCellRenderer(TableCellRenderer renderer) {
        this.setName("Table.cellRenderer");
        this.setHorizontalAlignment(0);
        Border dBorder = renderer == null ? new EmptyBorder(0, 0, 0, 0) : ((JComponent)((Object)renderer)).getBorder();
        Insets dInsets = dBorder == null ? new Insets(0, 0, 0, 0) : dBorder.getBorderInsets(null);
        Border fb = UIManager.getBorder("Table.focusCellHighlightBorder");
        Border fBorder = fb == null ? new EmptyBorder(0, 0, 0, 0) : fb;
        Insets fInsets = fBorder.getBorderInsets(null);
        Insets insets = new Insets(dInsets.top - fInsets.top, dInsets.left - fInsets.left, dInsets.bottom - fInsets.bottom, dInsets.right - fInsets.right);
        this.focusBorder = new CompoundBorder(fBorder, new EmptyBorder(insets));
        this.noFocusBorder = new CompoundBorder(new EmptyBorder(fInsets), new EmptyBorder(insets));
        this.alternateColor = SyntheticaLookAndFeel.getColor("Table.alternateRowColor", null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.isRowSelected = isSelected;
        if (isSelected) {
            this.setForeground(this.unwrap(table.getSelectionForeground()));
            this.setBackground(this.unwrap(table.getSelectionBackground()));
        } else {
            this.setForeground(this.unwrap(table.getForeground()));
            Color background = table.getBackground();
            if ((background == null || background instanceof UIResource) && this.alternateColor != null && row % 2 == 1) {
                this.setBackground(this.alternateColor);
            } else {
                this.setBackground(this.unwrap(background));
            }
        }
        this.setSelected(value != null && (Boolean)value != false);
        if (hasFocus) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
        return this;
    }

    private Color unwrap(Color c) {
        if (c instanceof UIResource) {
            return new Color(c.getRGB());
        }
        return c;
    }

    @Override
    public boolean isOpaque() {
        return this.isRowSelected ? true : super.isOpaque();
    }

    @Override
    public boolean isBorderPainted() {
        return true;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

