/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.SynthContext;

public class ToolBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ToolBarPainter";

    protected ToolBarPainter() {
    }

    public static ToolBarPainter getInstance() {
        return ToolBarPainter.getInstance(null);
    }

    public static ToolBarPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ToolBarPainter.getPainterClassName(sc, ToolBarPainter.class, UI_KEY));
        if (instance == null) {
            instance = ToolBarPainter.getInstance(sc, ToolBarPainter.class, UI_KEY);
        }
        return (ToolBarPainter)instance;
    }

    public void paintToolBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintToolBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintToolBarBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), g, x, y, w, h);
    }

    public void paintToolBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Container parent = c.getRootPane().getParent();
        boolean active = true;
        if (parent instanceof Window) {
            active = ((Window)parent).isActive();
        } else if (parent instanceof JInternalFrame) {
            active = ((JInternalFrame)parent).isSelected();
        }
        String imagePath = "Synthetica.toolBar.background";
        if (!active && this.resolveImagePath(String.valueOf(imagePath) + ".inactive", c) != null) {
            imagePath = String.valueOf(imagePath) + ".inactive";
        }
        if ((imagePath = this.resolveImagePath(imagePath, c)) != null && SyntheticaLookAndFeel.isOpaque(c)) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.toolBar.background.insets", c);
            int xPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.background.horizontalTiled", c)) {
                xPolicy = 1;
            }
            int yPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.background.verticalTiled", c)) {
                yPolicy = 1;
            }
            UIKey key = new UIKey("toolBar.background", state);
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, active ? 0 : 6);
            ImagePainter iPainter = new ImagePainter(c, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            iPainter.draw();
            imagePath = "Synthetica.toolBar.background.light";
            imagePath = this.resolveImagePath(imagePath, c);
            if (imagePath != null) {
                iPainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                iPainter.draw();
            }
            imagePath = "Synthetica.toolBar.background.light2";
            if ((imagePath = this.resolveImagePath(imagePath, c)) != null) {
                iPainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                iPainter.draw();
            }
        }
    }

    public void paintToolBarContentBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintToolBarContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintToolBarDragWindowBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintToolBarDragWindowBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), g, x, y, w, h, ((JToolBar)sc.getComponent()).getOrientation());
    }

    public void paintToolBarDragWindowBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        UIKey key = new UIKey("toolBar.dragBackground.image", state);
        Insets dInsets = sInsets = (Insets)UIKey.findProperty(c, key.get(), "insets", 1);
        String imagePath = this.resolveImagePath(key.get(), c);
        if (imagePath != null) {
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 1, 1);
            imagePainter.draw();
        } else {
            int cw = c.getWidth();
            int ch = c.getHeight();
            boolean horizontal = orientation == 0;
            boolean preview = false;
            if (horizontal && h == ch || !horizontal && w == cw) {
                preview = true;
            }
            if (preview && imagePath == null) {
                BufferedImage image = new BufferedImage(w, h, 2);
                c.paint(image.getGraphics());
                g.drawImage(image, 0, 0, null);
            }
        }
    }

    public void paintToolBarDragWindowBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintToolBarDragWindowBorder(sc.getComponent(), new SyntheticaState(sc.getComponentState()), g, x, y, w, h, ((JToolBar)sc.getComponent()).getOrientation());
    }

    public void paintToolBarDragWindowBorder(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        UIKey key = new UIKey("toolBar.dragBorder.image", state);
        Insets dInsets = sInsets = (Insets)UIKey.findProperty(c, key.get(), "insets", 1);
        String imagePath = this.resolveImagePath(key.get(), c);
        if (imagePath != null) {
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 1, 1);
            imagePainter.drawBorder();
        }
    }
}

