/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.combobox.controls;

import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.ColorComboBoxRenderer;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorPopupPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ListSelectionListener {
    private JYComboBox comboBox;
    private JList<Color> list;
    private JSeparator separator;
    private AbstractButton nonColorButton;
    private AbstractButton otherColorButton;
    private Dimension colorCellDimension;
    private static String delimiter = ",";

    public ColorPopupPanel(JYComboBox comboBox) {
        this.comboBox = comboBox;
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "enterPressed");
        this.getActionMap().put("enterPressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPopupPanel.this.setSelectedListItemAsComboBoxItem();
            }
        });
        this.setLayout(new GridBagLayout());
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.list.addMouseMotionListener(this);
        this.setColorCellDimension(SyntheticaLookAndFeel.getInstance().scaleDimension(14, 14));
        this.setColorRows(7);
        this.setColors(this.createNaturalColorPalette());
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Color color = (Color)value;
                this.setIcon(new ColorIcon(color, ((ColorPopupPanel)ColorPopupPanel.this).colorCellDimension.width, ((ColorPopupPanel)ColorPopupPanel.this).colorCellDimension.height));
                this.setText("");
                ListCellRenderer r = ColorPopupPanel.this.comboBox.getRenderer();
                if (r instanceof ColorComboBoxRenderer && ((ColorComboBoxRenderer)r).isAlphaValueIncluded()) {
                    this.setToolTipText(color == null ? null : Integer.toHexString(color.getRGB()).substring(0).toUpperCase());
                } else {
                    this.setToolTipText(color == null ? null : Integer.toHexString(color.getRGB()).substring(2).toUpperCase());
                }
                return this;
            }
        });
        this.add(this.list, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 0, 0), 0, 0));
        this.separator = new JSeparator(0);
        this.add((Component)this.separator, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(4, 0, 4, 0), 0, 0));
        this.nonColorButton = new JButton(new AbstractAction(UIManager.getString("JYComboBox.colorPopup.noColor")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPopupPanel.this.comboBox.closePopup();
                ColorPopupPanel.this.setSelectedComboBoxItem(null);
            }
        });
        this.nonColorButton.setName("ColorPopupPanel.NonColorButton");
        this.insertComponentAt(this.nonColorButton, 2);
        this.otherColorButton = new JButton(new AbstractAction(UIManager.getString("JYComboBox.colorPopup.otherColor")){
            private static final long serialVersionUID = -5960946612368469089L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPopupPanel.this.comboBox.closePopup();
                Color selectedColor = (Color)ColorPopupPanel.this.comboBox.getSelectedItem();
                Window w = SwingUtilities.getWindowAncestor(ColorPopupPanel.this.comboBox);
                Color color = JColorChooser.showDialog(w, "Select a color...", selectedColor);
                if (color != null) {
                    ColorPopupPanel.this.setSelectedComboBoxItem(color);
                }
            }
        });
        this.otherColorButton.setName("ColorPopupPanel.OtherColorButton");
        this.insertComponentAt(this.otherColorButton, 3);
        this.setNonColorButtonVisible(true);
        this.setOtherColorButtonVisible(true);
    }

    public void insertComponentAt(Component component, int index) {
        GridBagConstraints gbc = new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 10, 2, SyntheticaLookAndFeel.getInstance().scaleInsets(index == 0 ? 4 : 0, 4, 4, 4), 0, 0);
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        int i = gbc.gridy;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            GridBagConstraints gbc_ = layout.getConstraints(c);
            ++gbc_.gridy;
            layout.setConstraints(c, gbc_);
            ++i;
        }
        this.add(component, gbc);
    }

    private void updateSeparatorVisibility() {
        this.separator.setVisible(this.otherColorButton.isVisible() || this.nonColorButton.isVisible());
    }

    public void setColorRows(int rows) {
        this.list.setVisibleRowCount(rows);
    }

    public int getColorRows() {
        return this.list.getVisibleRowCount();
    }

    public void setColorCellDimension(Dimension d) {
        this.colorCellDimension = d;
    }

    public Dimension getColorCellDimension() {
        return this.colorCellDimension;
    }

    public void setNonColorButtonVisible(boolean b) {
        this.nonColorButton.setVisible(b);
        this.updateSeparatorVisibility();
    }

    public boolean isNonColorButtonVisible() {
        return this.nonColorButton.isVisible();
    }

    public void setOtherColorButtonVisible(boolean b) {
        this.otherColorButton.setVisible(b);
        this.updateSeparatorVisibility();
    }

    public boolean isOtherColorButtonVisible() {
        return this.otherColorButton.isVisible();
    }

    public void setColors(Color[] colors) {
        DefaultListModel<Color> model = new DefaultListModel<Color>();
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            model.addElement(color);
            ++n2;
        }
        this.list.setModel(model);
    }

    public Color[] getColors() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        Color[] colors = new Color[model.getSize()];
        int i = 0;
        while (i < colors.length) {
            colors[i] = (Color)model.get(i);
            ++i;
        }
        return colors;
    }

    public Color[] createLinearColorPalette(int distance) {
        int rows = this.getColorRows();
        int[] values = new int[256 / distance + 1];
        int i = 0;
        while (i < values.length) {
            values[i] = i * distance;
            ++i;
        }
        int n = values.length - 1;
        values[n] = values[n] - 1;
        Color[] colors = new Color[values.length * rows];
        int row = 0;
        while (row < rows) {
            int j = 0;
            while (j < values.length) {
                int r = (rows - row & 4) == 0 ? 0 : values[j] << 16;
                int g = (rows - row & 2) == 0 ? 0 : values[j] << 8;
                int b = (rows - row & 1) == 0 ? 0 : values[j];
                colors[row * values.length + j] = new Color(r | g | b);
                ++j;
            }
            ++row;
        }
        return colors;
    }

    public Color[] createWebColorPalette() {
        int[] nArray = new int[6];
        nArray[1] = 51;
        nArray[2] = 102;
        nArray[3] = 153;
        nArray[4] = 204;
        nArray[5] = 255;
        int[] vals = nArray;
        int len = vals.length;
        Color[] colors = new Color[len * len * len];
        int i = 0;
        while (i < vals.length) {
            int j = 0;
            while (j < vals.length) {
                int k = 0;
                while (k < vals.length) {
                    int rgb = vals[i] << 16 | vals[j] << 8 | vals[k];
                    colors[i * len * len + j * len + k] = new Color(rgb);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return colors;
    }

    public Color[] createNaturalColorPalette() {
        Color[] colors = new Color[]{new Color(0xFFFFFF), new Color(0), new Color(0xFF0000), new Color(0xFF0099), new Color(0xFF00FF), new Color(0x9900FF), new Color(255), new Color(39423), new Color(65535), new Color(65433), new Color(65280), new Color(0x99FF00), new Color(0xFFFF00), new Color(0xFF9900)};
        return this.createColorVariants(colors);
    }

    public Color[] createColorVariants(Color[] baseColors) {
        float bPower = 1.4f;
        int rows = this.getColorRows();
        Color[] colors = new Color[baseColors.length * rows];
        int i = 0;
        while (i < baseColors.length) {
            Color color = baseColors[i];
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            colors[i] = baseColors[i];
            int row = 1;
            while (row < rows) {
                float bFactor = (float)(row - 1) / (float)rows;
                bFactor = (float)Math.pow(bFactor, bPower);
                float brightness = 1.0f - bFactor;
                if (hsb[1] == 0.0f) {
                    float max = 0.5f + 0.5f * hsb[2];
                    brightness = max * (float)(rows - row + 1) / (float)rows;
                }
                colors[i + row * baseColors.length] = new Color(Color.HSBtoRGB(hsb[0], hsb[1] * (float)(row + 1) / (float)(rows + 1), brightness));
                ++row;
            }
            ++i;
        }
        return colors;
    }

    private void setSelectedListItemAsComboBoxItem() {
        if (this.list.getSelectedIndex() < 0) {
            return;
        }
        this.setSelectedComboBoxItem(this.list.getModel().getElementAt(this.list.getSelectedIndex()));
    }

    private void setSelectedComboBoxItem(Object item) {
        this.comboBox.setItem(item);
        this.comboBox.closePopup();
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.list.setSelectedIndex(this.list.locationToIndex(evt.getPoint()));
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.setSelectedListItemAsComboBoxItem();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    static Color parseColor(String text, boolean includeAlphaValue) throws ParseException {
        int numberOfNumbers = includeAlphaValue ? 4 : 3;
        String[] numbers = text.split(delimiter);
        int[] vals = new int[numberOfNumbers];
        if (numbers.length != numberOfNumbers) {
            throw new ParseException("Required number: " + numberOfNumbers, -1);
        }
        int i = 0;
        while (i < vals.length) {
            try {
                vals[i] = Integer.parseInt(numbers[i].trim());
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), -1);
            }
            ++i;
        }
        Color color = null;
        try {
            color = vals.length == 3 ? new Color(vals[0], vals[1], vals[2]) : new Color(vals[0], vals[1], vals[2], vals[3]);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return color;
    }

    static String colorAsText(Color color, boolean hexadecimal, boolean includeAlphaValue) {
        String s = null;
        if (hexadecimal) {
            s = includeAlphaValue ? Integer.toHexString(color.getRGB()).toUpperCase() : Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
        } else {
            s = String.valueOf(color.getRed()) + delimiter + " " + color.getGreen() + delimiter + " " + color.getBlue();
            if (includeAlphaValue) {
                s = String.valueOf(s) + delimiter + " " + color.getAlpha();
            }
        }
        return s;
    }

    public static class ColorIcon
    extends Color
    implements Icon {
        private boolean nullColor;
        private int width;
        private int height;

        public ColorIcon(Color color, int width, int height) {
            super(color == null ? 0 : color.getRGB(), true);
            this.nullColor = color == null;
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paint(c, g, x, y, this.getIconWidth(), this.getIconHeight());
        }

        private void paint(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this);
            if (!this.nullColor) {
                if (this.getAlpha() < 255) {
                    g2.setColor(Color.WHITE);
                    g2.fillRect(x, y, w, h);
                    g2.setColor(new Color(0x808080));
                    g2.fillRect(x, y, w / 2, h / 2);
                    g2.fillRect(x + w / 2, y + h / 2, w / 2, h / 2);
                    g2.setColor(this);
                }
                g2.fillRect(x, y, w, h);
            }
            if (this.nullColor) {
                Color foreground;
                Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color = foreground = c.getParent().getParent().hasFocus() ? UIManager.getColor("Synthetica.comboBox.focused.textColor") : UIManager.getColor("Synthetica.comboBox.locked.textColor");
                if (foreground == null) {
                    foreground = c.getForeground();
                }
                foreground = new Color(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), 192);
                g2.setColor(foreground);
                g2.drawLine(x, y, x + w - 1, y + h - 1);
                g2.drawLine(x, y + h - 1, x + w - 1, y);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            } else {
                g2.setColor(new Color(0x40000000, true));
            }
            g2.drawRect(x, y, w - 1, h - 1);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

