/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.DataFrameWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractDataFrameWriter
implements DataFrameWriter {
    protected TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private Map<Object, Boolean> containsTime = new HashMap<Object, Boolean>();
    private static DecimalFormat decimalFormat = new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH));

    public void start() throws IOException {
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static String numberToString(Number value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            double v = value.doubleValue();
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                return decimalFormat.format(value);
            }
            return new BigDecimal(v, new MathContext(15, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Float) {
            float v = value.floatValue();
            if (Float.isNaN(v) || Float.isInfinite(v)) {
                return decimalFormat.format(value);
            }
            return new BigDecimal(v, new MathContext(6, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Long) {
            long v = value.longValue();
            return Long.toString(v);
        }
        if (value instanceof Integer) {
            int v = value.intValue();
            return Integer.toString(v);
        }
        if (value instanceof Byte) {
            byte v = value.byteValue();
            return Byte.toString(v);
        }
        if (value instanceof Short) {
            short v = value.shortValue();
            return Short.toString(v);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    public String dateToString(DataFrame dataFrame, Object column, Date date) {
        return this.dateToString(dataFrame, column, date, this.timeZone);
    }

    public String dateToString(DataFrame dataFrame, Object column, Date date, TimeZone timeZone) {
        DateFormat dateFormat = this.getDateFormat(dataFrame, column, timeZone);
        return dateFormat.format(date);
    }

    private DateFormat getDateFormat(DataFrame dataFrame, Object column, TimeZone timeZone) {
        this.hasTime(dataFrame, column, timeZone);
        SimpleDateFormat dateFormat = this.hasTime(dataFrame, column, timeZone) ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    protected boolean hasTime(DataFrame dataFrame, Object column, TimeZone timeZone) {
        if (!this.containsTime.containsKey(column)) {
            boolean containsTime = false;
            for (Object row : dataFrame.rows()) {
                Date value = (Date)dataFrame.getValueAt(row, column);
                if (value == null) continue;
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTime(value);
                if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) continue;
                containsTime = true;
            }
            this.containsTime.put(column, containsTime);
        }
        return this.containsTime.get(column);
    }
}

