/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.crossplatform.CPHelper;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.swing.AbstractTreeMapFieldComboBoxModel;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

class BackgroundComboBoxModel<N extends MutableTreeMapNode>
extends AbstractTreeMapFieldComboBoxModel {
    private final CPHelper cpHelper;

    BackgroundComboBoxModel(TreeMapModel<N, ?, ?, ?, ?> treeMapModel, CPHelper cpHelper) {
        super(treeMapModel, "backgroundField", true);
        this.cpHelper = cpHelper;
    }

    @Override
    protected void updateComboBox() {
        this.setSelectedItem(this.treeMapModel.getSettings().getBackgroundTreeMapField());
    }

    @Override
    protected void updateTreeMap() {
        Object selectedItem = this.getSelectedItem();
        this.treeMapModel.getSettings().setBackgroundTreeMapField((TreeMapField)selectedItem);
    }

    @Override
    protected boolean accept(TreeMapField field) {
        Class type = field.getType();
        return !type.isArray() && (this.cpHelper.isAssignableFrom(BufferedImage.class, type) || this.cpHelper.isAssignableFrom(Icon.class, type));
    }
}

