/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.ConflictList;
import com.treemap.swing.fastvoronoi.originalconvexhull.Point3d;

public class Vertex {
    public double x;
    public double y;
    public double z;
    private static final double epsilon = 1.0E-10;
    private ConflictList list = new ConflictList(false);
    private int index = -1;
    private boolean handled;
    public Object originalObject;

    public Vertex(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ConflictList getList() {
        return this.list;
    }

    public void setList(ConflictList list) {
        this.list = list;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex obj = (Vertex)o;
        return obj.x == this.x && obj.y == this.y && obj.z == this.z;
    }

    public boolean linearDependent(Vertex v) {
        if (this.x == 0.0 && v.x == 0.0) {
            if (this.y == 0.0 && v.y == 0.0) {
                if (this.z == 0.0 && v.z == 0.0) {
                    return true;
                }
                return this.z != 0.0 && v.y != 0.0;
            }
            if (this.y == 0.0 || v.y == 0.0) {
                return false;
            }
            return this.z / this.y >= v.z / v.y - 1.0E-10 && this.z / this.y <= v.z / v.y + 1.0E-10;
        }
        if (this.x == 0.0 || v.x == 0.0) {
            return false;
        }
        return this.y / this.x <= v.y / v.x + 1.0E-10 && this.y / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x >= v.y / v.x - 1.0E-10 && this.z / this.x <= v.z / v.x + 1.0E-10;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public Vertex subtract(Vertex v) {
        return new Vertex(v.x - this.x, v.y - this.y, v.z - this.z);
    }

    public Vertex crossProduct(Vertex v) {
        return new Vertex(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public String toString() {
        return this.x + "/" + this.y + "/" + this.z;
    }

    public void setHandled(boolean b) {
        this.handled = b;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public Point3d toPoint3D() {
        return new Point3d(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void clear() {
        this.list = new ConflictList(false);
        this.index = -1;
        this.handled = false;
    }
}

